% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.multi.fwf.R
\name{read.multi.fwf}
\alias{read.multi.fwf}
\title{Read Fixed Width Format Files containing lines of different Type}
\usage{
read.multi.fwf(file, multi.specs, select, header = FALSE, sep = "\\t",
  skip = 0, n = -1, buffersize = 2000, ...)
}
\arguments{
\item{file}{the name of the file which the data are to be read from.

Alternatively, file can be a \link{connection}, which will be opened if necessary, and if so closed at the end of the function call.}

\item{multi.specs}{A named list of data.frames containing the following columns:
    \tabular{ll}{
        widths \tab   see \link{read.fwf}\cr
        col.names \tab see \link{read.table}\cr
        row.names \tab see \link{read.table}\cr
    }

For more info on these fields see \code{\link{read.fwf}}.

Note that each list item should have a name. This is important for the select function.}

\item{select}{A function to select the type of a line. This selector should have parameters:
    \tabular{ll}{
        line \tab   the line\cr
        specs \tab  the multi.specs list that was passed to read.multi.fwf\cr
    }
    
The select function should return the name of the spec that matches the line. read.multi.fwf will then use this name to select the a spec from the passed multi.spec. This is why multi.spec should be a named list. 
If there is no match then NULL can be returned.}

\item{header}{a logical value indicating whether the file contains the names of the variables as its first line. If present, the names must be delimited by sep.}

\item{sep}{character; the separator used internally; should be a character that does not occur in the file (except in the header).}

\item{skip}{number of initial lines to skip; see \link{read.fwf}.}

\item{n}{the maximum number of records (lines) to be read, defaulting to no limit.}

\item{buffersize}{Maximum number of lines to read at one time}

\item{...}{further arguments to be passed to \link{read.fwf}.}
}
\value{
Return value is a named list with an item for each spec in multi.spec. If there was at least one line in file, matching a spec, then the named item will be a \link{data.frame}. Otherwise it will be NULL.
}
\description{
Read a table of fixed width formatted data of different types into a \link{data.frame} for each type.
}
\details{
Known bugs:
Warnings on connections that are left open. Haven't figured this out yet. Somehow some files are left opened.
}
\examples{
ff <- tempfile()
cat(file = ff, '123456', '287654', '198765', sep = '\\n')
specs <- list()
specs[['sp1']] = data.frame(widths = c(1, 2, 3), 
                            col.names = c('Col1', 'Col2', 'Col3'))
specs[['sp2']] = data.frame(widths = c(3, 2, 1), 
                            col.names = c('C1', 'C2', 'C3'))

myselector <- function(line, specs) {
    s <- substr(line, 1, 1)
    spec_name = ''
    if (s == '1')
        spec_name = 'sp1'
    else if (s == '2')
        spec_name = 'sp2'

    spec_name
}

read.multi.fwf(ff, multi.specs = specs, select = myselector)    
#> sp1: 1 23 456 \\ 1 98 765, sp2: 287 65 4

unlink(ff)
}
\author{
Panos Rontogiannis \email{p.g.ronto@gmail.com}
}
\seealso{
\code{\link{read.fwf}}
}

