% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrast.R
\name{effect_summary}
\alias{effect_summary}
\title{Average Effects across j}
\usage{
effect_summary(effects)
}
\arguments{
\item{effects}{The output from direct_effect or indirect_effect. A data.frame
containing effect estimates for each variable and indirect/direct setting
along rows.}
}
\value{
A version of the input with all indirect/direct settings averaged
over.
}
\description{
This averages direct or indirect effects across settings j, leading to
the effect estimates given in equation (10) of the preprint.
}
\examples{
# example with null data
exper <- demo_joy() |>
    mediation_data("PHQ", "treatment", starts_with("ASV"))
multimedia(exper) |>
    estimate(exper) |>
    direct_effect() |>
    effect_summary()

# example with another dataset
exper <- demo_spline(tau = c(2, 1)) |>
    mediation_data(starts_with("outcome"), "treatment", "mediator")
multimedia(exper) |>
    estimate(exper) |>
    direct_effect() |>
    effect_summary()
}
\seealso{
direct_effect indirect_effect
}
