% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/critical_effect_size_additive.R
\name{critical_effect_size_additive}
\alias{critical_effect_size_additive}
\title{Critical Effect Sizes (for the additive null model)}
\usage{
critical_effect_size_additive(
  Control_N,
  StressorA_N,
  StressorB_N,
  StressorsAB_N,
  Small_Sample_Correction,
  Significance_Level
)
}
\arguments{
\item{Control_N}{Sample size of the control treatment (numeric)}

\item{StressorA_N}{Sample size of stressor A treatment (numeric)}

\item{StressorB_N}{Sample size of stressor B treatment (numeric)}

\item{StressorsAB_N}{Sample size of stressors A and B treatment (numeric)}

\item{Small_Sample_Correction}{Whether the correction for small sample sizes should be enacted
(TRUE or FALSE; default is TRUE)}

\item{Significance_Level}{The value of alpha for which confidence intervals are calculated
(numeric, between 0 and 1; default is 0.05)}
}
\value{
The function returns the critical effect size (for the additive null model; see \code{\link{effect_size_additive}})
for a given experimental design.
}
\description{
The critical effect size for a given experimental design (i.e., number of replicates per treatment).
}
\details{
The critical effect size represents the minimum effect size required for a significant result to be returned
(see Burgess et al. (2021)).

For the additive null model, the critical effect size is directly related to treatment sample sizes.
}
\examples{
critical_effect_size_additive(Control_N     = 4,
                             StressorA_N   = 4,
                             StressorB_N   = 4,
                             StressorsAB_N = 4)

critical_effect_size_additive(Control_N     = 3,
                             StressorA_N   = 3,
                             StressorB_N   = 3,
                             StressorsAB_N = 3,
                             Small_Sample_Correction = FALSE,
                             Significance_Level = 0.10)

}
\references{
Burgess, B. J., Jackson, M. C., & Murrell, D. J. (2021). Multiple stressor null models frequently fail to detect most interactions due to low statistical power. \emph{bioRxiv}.
}
