% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiview.R
\name{plot.multiview}
\alias{plot.multiview}
\title{Plot coefficients from a "multiview" object}
\usage{
\method{plot}{multiview}(x, col_palette = NULL, label = FALSE, ...)
}
\arguments{
\item{x}{A fitted \code{"multiview"} model.}

\item{col_palette}{A set of colors to use for indicating different views. If \code{NULL},
the function will use the color palette "Set1" from the \code{RColorBrewer} package.}

\item{label}{If \code{TRUE}, label the curves with variable sequence.
numbers.}

\item{\dots}{Other graphical parameters to plot.}
}
\value{
a \code{NULL} value as this function is really meant for its side-effect of generating a plot.
}
\description{
Produces a coefficient profile plot of the coefficient paths for a fitted
\code{"multiview"} object. The paths are colored by the data views, from which the features come.
}
\examples{
# Gaussian
x = matrix(rnorm(100 * 20), 100, 20)
z = matrix(rnorm(100 * 10), 100, 10)
y = rnorm(100)
fit1 = multiview(list(x=x,z=z), y, rho = 0)
plot(fit1, label = TRUE)

# Binomial
by = sample(c(0,1), 100, replace = TRUE)
fit2 = multiview(list(x=x,z=z), by, family = binomial(), rho=0.5)
plot(fit2, label=FALSE)

# Poisson
py = matrix(rpois(100, exp(y))) 
fit3 = multiview(list(x=x,z=z), py, family = poisson(), rho=0.5)
plot(fit3, label=TRUE)

}
