% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brightness_comparisons.R
\name{eps}
\alias{eps}
\alias{delta}
\alias{ratio}
\title{The brightness ratio}
\usage{
eps(set, edo = 12, rounder = 10)

delta(set, edo = 12, rounder = 10)

ratio(set, edo = 12, rounder = 10)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
Single non-negative numeric value
}
\description{
Section 3.3 of "Modal Color Theory" describes a "brightness ratio" which characterizes
the modes of a scale in terms of how well "sum brightness" acts as a proxy for "voice-leading
brightness." Scales with a brightness ratio less than 1 are pretty well behaved from this
perspective, while ones with a brightness ratio greater than 1 are poorly behaved. When the
brightness ratio is 0, sum brightness and voice-leading brightness give exactly the same
results. (This can happen for sets on two extremes: those like the diatonic scale which are
well formed and those like the Weitzmann scales, which differ from "white" in only one
scale degree.)

I wish I had come up with a more descriptive name than "brightness ratio" for this
property, because it's not really a ratio of brightness in the sense you might expect (i.e.
"this scale is 20\% bright"). Rather, it's a ratio of two brightness-related properties,
\code{delta} and \code{eps}. "Modal Color Theory" (p. 20) offers definitions of these. Delta is
"the largest sum difference between (voice-leading) incomparable modes," with value 0 by
definition if all of the modes are comparable. ("This, in a sense, is a measure of how badly
voice-leading brightness breaks down from the perspective of sum brightness.") \strong{Eps}ilon
"represents the smallest sum difference between non-identical but comparable modes."
This is harder to give an intuitive gloss on, but my attempt in "MCT" was "Essentially,
epsilon measures the finest distinction that voice-leading brightness is capable of
parsing."

The brightness ratio (\code{ratio}) itself is simply delta divided by epsilon.
}
\examples{
harmonic_minor <- c(0, 2, 3, 5, 7, 8, 11)
hypersaturated_harmonic_minor <- saturate(2, harmonic_minor)
c(delta(harmonic_minor), eps(harmonic_minor))
c(delta(hypersaturated_harmonic_minor), eps(hypersaturated_harmonic_minor))

# Delta and epsilon depend on the precise scale, but ratio() is constant on a hue
ratio(harmonic_minor)
ratio(hypersaturated_harmonic_minor)

#### Sort all 12tet heptachords by brightness ratio
heptas12 <- unique(apply(combn(12, 7), 2, primeform),MARGIN=2)
hepta_ratios <- apply(heptas12, 2, ratio)
sorted_heptas <- heptas12[, order(hepta_ratios)]
colnames(sorted_heptas) <- apply(sorted_heptas, 2, fortenum)
sorted_heptas

#### Compare evenness to ratio for 12tet hetpachords
plot(apply(heptas12, 2, evenness), hepta_ratios, xlab="Evenness", ylab="Brightness Ratio")

}
