% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_duration.R
\name{typeToMXLDuration}
\alias{typeToMXLDuration}
\title{(type-dot-triplet) to MXL duration}
\usage{
typeToMXLDuration(type, dot = FALSE, triplet = FALSE, mxlDivision = 96)
}
\arguments{
\item{type}{Integer in 2^(0:6), note type (longest 1=whole, shortest 64=64th).
1 = whole, 2 = half, 4 = quarter, 8 = eighth, etc. down to 64 = 64th}

\item{dot}{Logical, is note dotted?}

\item{triplet}{Logical, is note triplet? (play 3 for 2)}

\item{mxlDivision}{Positive integer, musicXML "division" defining the
time resolution, i.e. the shortest possible note.
It is expressed as a fraction of a quarter note.
The value of 96 allows allows using 64th notes and their triplet/dotted versions.}
}
\value{
An integer representing the mxl duration expressed in number of mxlDivision
}
\description{
Convert a (type-dot-triplet) into a MusicXML duration
}
\examples{
typeToMXLDuration(type=8,dot=TRUE)
}
