% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hatvalues.mlm.R
\name{hatvalues.mlm}
\alias{hatvalues.mlm}
\title{Hatvalues for a MLM}
\usage{
\method{hatvalues}{mlm}(model, m = 1, infl, ...)
}
\arguments{
\item{model}{An object of class \code{mlm}, as returned by \code{\link[stats]{lm}}}

\item{m}{The size of subsets to be considered}

\item{infl}{An \code{inflmlm} object, as returned by \code{mlm.influence}}

\item{...}{Other arguments, for compatibility with the generic; ignored.}
}
\value{
A vector of hatvalues
}
\description{
The functions \code{cooks.distance.mlm} and \code{hatvalues.mlm} are
designed as extractor functions for regression deletion diagnostics for
multivariate linear models following Barrett & Ling (1992). These are close
analogs of methods for univariate and generalized linear models handled by
the \code{\link[stats]{influence.measures}} in the \code{stats} package.
}
\details{
Hat values are a component of influence diagnostics, measuring the leverage or 
outlyingness of observations in the space of the predictor variables.  

The usual
case considers observations one at a time (\code{m=1}), where the hatvalue is 
proportional to the squared Mahalanobis distance, \eqn{D^2} of each observation
from the centroid of all observations. This function extends that definition
to calculate a comparable quantity for subsets of size \code{m>1}.
}
\examples{

data(Rohwer, package="heplots")
Rohwer2 <- subset(Rohwer, subset=group==2)
rownames(Rohwer2)<- 1:nrow(Rohwer2)
Rohwer.mod <- lm(cbind(SAT, PPVT, Raven) ~ n+s+ns+na+ss, data=Rohwer2)

options(digits=3)
hatvalues(Rohwer.mod)
cooks.distance(Rohwer.mod)
}
\references{
Barrett, B. E. and Ling, R. F. (1992). General Classes of
Influence Measures for Multivariate Regression. \emph{Journal of the
American Statistical Association}, \bold{87}(417), 184-191.
}
\seealso{
\code{\link{cooks.distance.mlm}}
}
\keyword{models}
\keyword{regression}
