% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{mhz}
\alias{mhz}
\title{Henze-Zirkler Test for Multivariate Normality}
\usage{
mhz(X)
}
\arguments{
\item{X}{an \eqn{n*p} numeric matrix or data frame.}
}
\value{
Returns a list with two objects:
\describe{
\item{\code{mv.test}}{results of the Henze-Zirkler test, i.e., test statistic, \emph{p}-value, and multivariate normality summary (YES, if \emph{p}-value>0.05).}
\item{\code{uv.shapiro}}{a dataframe with \eqn{p} rows detailing univariate Shapiro-Wilk tests. Columns in the dataframe contain test statistics \emph{W}, \emph{p}-value,and univariate normality summary (YES, if \emph{p}-value>0.05).}
}
}
\description{
It computes a multiviariate normality test based on a non-negative functional distance which
was proposed by Henze and Zirkler (1990). Under the null hypothesis the test statistic is approximately
log-normally distributed.
}
\examples{
set.seed(12345)

## Data from gamma distribution
X = matrix(rgamma(50*4,shape =  2),50)
mhz(X)

## Data from normal distribution
X = matrix(rnorm(50*4,mean = 2 , sd = 1),50)
mhz(X)

## load the ubiquitous multivariate iris data ##
## (first 50 observations of columns 1:4) ##
iris.df = iris[1:50, 1:4]
mhz(iris.df)
}
\references{
Henze, N., & Zirkler, B. (1990). A class of invariant consistent tests for multivariate normality. \emph{Communications in statistics-Theory and Methods}, 19(10), 3595-3617.

Shapiro, S. S., & Wilk, M. B. (1965). An analysis of variance test for normality (complete samples). \emph{Biometrika}, 52(3/4), 591-611.

Zhou, M., & Shao, Y. (2014). A powerful test for multivariate normality. \emph{Journal of applied statistics}, 41(2), 351-363.
}
\seealso{
\code{\link{power.mhz}}, \code{\link{mvnTest}}, \code{\link{faTest}}, \code{\link{msw}}, \code{\link{msk}}, \code{\link{mardia}}, \code{\link[MVN]{mvn}}
}
