\name{plot.mvout}
\alias{plot.mvout}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Plot Method for mvout Objects
}
\description{
Default S3 plot method for objects of class "mvout".
}
\usage{
\method{plot}{mvout}(x, outcol = "red", incol = "black", outpch = 0, inpch = 1,
     xlab = "PC1", ylab = "PC2", xresign = FALSE, yresign = FALSE, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{
Object of class \code{mvout}.
}
  \item{outcol}{
Color used for cases labeled as outliers.
  }
  \item{incol}{
Color used for cases not labeled as outliers.
  }
  \item{outpch}{
Plotting character used for cases labeled as outliers.
  }
  \item{inpch}{
Plotting character used for cases not labeled as outliers.
  }
  \item{xlab}{
Label for the x-axis.
  }
  \item{ylab}{
Label for the y-axis.
  }
  \item{xresign}{
Logical argument. If \code{TRUE}, values on x-axis have their signs reversed. This is primarlity for improved visualization.
  }
  \item{yresign}{
Logical argument. If \code{TRUE}, values on y-axis have their signs reversed. This is primarlity for improved visualization.
  }
  \item{...}{
Additional arguments passed to the \code{\link{plot}} function, e.g., \code{cex}, \code{main}, etc.
  }
}
\details{
Produces a bivariate plot highlighting cases that have been flagged as outliers. If \code{method = "princomp"} or \code{method = "factanal"} was used, then the \code{scores} component of \code{x} is plotted. Otherwise the data are projected onto the first two principal components for visualization.
}
\value{
A plot is produced and nothing is returned.
}

%\references{
%Delgado, J. E., Elison, J. T., & Helwig, N. E. (2025). Robust Detection of Signed Outliers in Multivariate Data With Applications to
%Early Identification of Risk for Autism. Psychological Methods. (conditionally accepted)
%}

\author{
Jesus E. Delgado <delga220@umn.edu>
Nathaniel E. Helwig <helwig@umn.edu>
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{mvout}}
}
\examples{
# load package and data
library(mvout)
data(pheno)
X <- pheno[,3:9]

# Example using pheno dataset
dir <- c(rep("greater", 4), rep("less", 2), "greater")
set.seed(1)    # for reproducible MCD estimate
out <- mvout(X, method = "princomp", rotation = "promax", direction = dir)
plot(out, outpch = 4)}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory (show via RShowDoc("KEYWORDS")):
\keyword{ hplot }
\keyword{ multivariate }
% Use only one keyword per line.
% For non-standard keywords, use \concept instead of \keyword:
% \concept{ ~cpt1 }
% \concept{ ~cpt2 }
% Use only one concept per line.
