% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mxMmodModel.R
\name{mxMmodModel}
\alias{mxMmodModel}
\title{Create an MMOD}
\usage{
mxMmodModel(
  data,
  modelName,
  idvar,
  timevar,
  structure,
  orthogonal = F,
  embed_dim = NULL,
  fiml = F
)
}
\arguments{
\item{data}{a data frame with measurements in long format}

\item{modelName}{name for the resulting model}

\item{idvar}{name of column for subject IDs}

\item{timevar}{name of column for measurement occasion}

\item{structure}{factor structure, see 'Details'}

\item{orthogonal}{if true, fix correlations between factors to 0
(A factor and its derivatives will still intercorrelate)}

\item{embed_dim}{time delay embedding dimension}

\item{fiml}{if true, use raw data to fit model with FIML. Otherwise, fit using cov matrix
(dropping missing values if necessary).}
}
\value{
an MMOD as an mxModel object
}
\description{
This function builds a Measurement Model of Derivatives (MMOD; Estabrook 2015) with a given
factor structure.
}
\details{
The \code{structure} argument is a list of latent factors and their mappings to manifest
variables. For example, a one factor structure would be:

\code{list(F1 = c('m1', 'm2', 'm3', 'm4', 'm5', 'm6'))}

And a two factor structure would be:

\code{list(F1 = c('m1', 'm2', 'm3'), F2 = c('m4', 'm5', 'm6'))}
}
\examples{
data(nlsy97depression)
# Fit one factor MMOD
structure <- list(
  F1 = c('nervous', 'down', 'depressed', 'calm', 'happy')
)
mmod_model <- mxMmodModel(data=nlsy97depression,
                          modelName='1 Factor MMOD',
                          idvar='pid', timevar='occasion', structure=structure)
mmod_fit <- OpenMx::mxRun(mmod_model)
summary(mmod_fit)
}
