% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.R
\name{mc_prep_calib_load}
\alias{mc_prep_calib_load}
\title{Load sensor calibration parameters to correct microclimatic records}
\usage{
mc_prep_calib_load(data, calib_table)
}
\arguments{
\item{data}{myClim object in Raw-format. see \link{myClim-package}}

\item{calib_table}{data.frame with columns (\code{serial_number}, \code{sensor_id}, \code{datetime}, \code{cor_factor}, \code{cor_slope})}
}
\value{
myClim object with loaded calibration information in metadata.
Microclimatic records are not calibrated, only ready for calibration.
To calibrate records run \code{\link[=mc_prep_calib]{mc_prep_calib()}}
}
\description{
This function loads calibration parameters from data.frame \emph{logger_calib_table}
and stores them in the myClim object metadata. This function
does not calibrate data. For calibration itself run \code{\link[=mc_prep_calib]{mc_prep_calib()}}
}
\details{
This function allows user to provide correction coefficients \code{cor_factor} and \code{cor_slope} for linear sensor calibration.
Calibrated data have by default the form of linear function terms:

\verb{calibrated value = original value * (cor_slope + 1) + cor_factor}

In case of one-point calibration, \code{cor_factor} can be estimated as:
\verb{cor_factor = reference value - sensor value}
and \code{cor_slope} should be set to 0.
This function loads sensor-specific
calibration coefficients from \emph{calib_table} and stores them into myClim Raw-format
object metadata. The \emph{calib_table} is data.frame with 5 columns:
\itemize{
\item serial_number = serial number of the logger
\item sensor_id = name of sensor, e.g. "TMS_T1"
\item datetime = the date of the calibration in POSIXct type
\item cor_factor = the correction factor
\item cor_slope = the slope of calibration curve (in case of one-point calibration, use cor_slope = 0)
}

It is not possible to change calibration parameters for already calibrated sensor.
This prevents repeated calibrations. Once \code{\link[=mc_prep_calib]{mc_prep_calib()}} is called then
it is not allowed to provide new calibration data, neither run calibration again.
}
