% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloset_bulk.R
\name{BulkPhyloExpressionSet_from_df}
\alias{BulkPhyloExpressionSet_from_df}
\title{Convert Data to BulkPhyloExpressionSet}
\usage{
BulkPhyloExpressionSet_from_df(
  data,
  groups = colnames(data[, 3:ncol(data)]),
  name = deparse(substitute(data)),
  strata_legend = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame where column 1 contains phylostratum information, 
column 2 contains gene IDs, and columns 3+ contain expression data}

\item{groups}{A factor or character vector indicating which group each sample belongs to.
Default uses column names from expression data}

\item{name}{A character string naming the dataset. Default uses the variable name}

\item{strata_legend}{A data frame with two columns: phylostratum assignments and name of each stratum. If NULL, no labels will be added (default: NULL)
If NULL, uses sorted unique values from column 1}

\item{...}{Additional arguments passed to BulkPhyloExpressionSet constructor}
}
\value{
A BulkPhyloExpressionSet object
}
\description{
Convert a data frame with phylostratum, gene ID, and expression data 
into a BulkPhyloExpressionSet object.
}
