% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotnScree.R
\name{plotnScree}
\alias{plotnScree}
\title{Scree Plot According to a nScree Object Class}
\usage{
plotnScree(
  nScree,
  legend = TRUE,
  ylab = "Eigenvalues",
  xlab = "Components",
  main = "Non Graphical Solutions to Scree Test"
)
}
\arguments{
\item{nScree}{Results of a previous \code{nScree} analysis}

\item{legend}{Logical indicator of the presence or not of a legend}

\item{ylab}{Label of the y axis (default to \code{"Eigenvalue"})}

\item{xlab}{Label of the x axis (default to \code{"Component"})}

\item{main}{Main title (default to \code{"Non Graphical Solutions to the
Scree Test"})}
}
\value{
Nothing returned.
}
\description{
Plot a scree plot adding information about a non graphical \code{nScree}
analysis.
}
\examples{
\dontrun{
if(interactive()){
## INITIALISATION
 data(dFactors)                      # Load the nFactors dataset
 attach(dFactors)
 vect         <- Raiche              # Use the second example from Buja and Eyuboglu
                                     # (1992, p. 519, nsubjects not specified by them)
 eigenvalues  <- vect$eigenvalues    # Extract the observed eigenvalues
 nsubjects    <- vect$nsubjects      # Extract the number of subjects
 variables    <- length(eigenvalues) # Compute the number of variables
 rep          <- 100                 # Number of replications for the parallel analysis
 cent         <- 0.95                # Centile value of the parallel analysis

## PARALLEL ANALYSIS (qevpea for the centile criterion, mevpea for the mean criterion)
 aparallel    <- parallel(var     = variables,
                          subject = nsubjects,
                          rep     = rep,
                          cent    = cent)$eigen$qevpea  # The 95 centile

## NOMBER OF FACTORS RETAINED ACCORDING TO DIFFERENT RULES
 results <- nScree(eig       = eigenvalues,
                   aparallel = aparallel
                   )

 results

## PLOT ACCORDING TO THE nScree CLASS
 plotnScree(results)
 }
}
}
\references{
Raiche, G., Walls, T. A., Magis, D., Riopel, M. and Blais, J.-G. (2013). Non-graphical solutions
for Cattell's scree test. Methodology, 9(1), 23-29.
}
\seealso{
\code{\link{plotuScree}}, \code{\link{nScree}},
\code{\link{plotParallel}}, \code{\link{parallel}}
}
\author{
Gilles Raiche \cr Centre sur les Applications des Modeles de
Reponses aux Items (CAMRI) \cr Universite du Quebec a Montreal\cr
\email{raiche.gilles@uqam.ca}
}
\keyword{Graphics}
