% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/njira.r
\name{jira.metadata}
\alias{jira.metadata}
\title{Jira Tables and Field Details}
\usage{
jira.metadata(table = NULL, fields = NULL)
}
\arguments{
\item{table}{Name of the Jira tables. If not specified, all the tables of the given interface are returned.}

\item{fields}{List of field names whose details are required. If not specified, all the fields of the specified tables are returned.}
}
\value{
Data frame of Jira tables and field names.
}
\description{
Returns the 'metadata' of Jira which includes 'table' and 'field' names, valid for respective Jira installation.
These table and field names can be referred while creating a Jira Query.
}
\examples{
fields <- jira.metadata()
fields <- jira.metadata(table = "history")
fields <- jira.metadata(table = "issues")
fields <- jira.metadata(table = "issues", fields = c("Created", "Date Required", "Dev Status"))

}
