% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InferenceFunctions.R
\name{bias.corrected.neyman}
\alias{bias.corrected.neyman}
\title{Bias-corrected Neyman Sample Average Treatment Effect Estimator}
\usage{
bias.corrected.neyman(Y, Z, pairs, pmat, xi)
}
\arguments{
\item{Y}{a 2I-length vector of outcome values}

\item{Z}{a 2I-length vector of treatment values}

\item{pairs}{an I x 2 dataframe containing the indices of observations
that form our set of matched pairs. An appropriate pairs dataframe can be
formed using the \link[nbpInference]{nbp.caliper} function.}

\item{pmat}{a 2I x 2I matrix where the diagonals equal zero, and the
off-diagonal elements (i, j) contain the probability the ith observation has
Z = max(Z_i, Z_j) and the jth observation has Z = min(Z_i, Z_j). We can create
a p-matrix using the make.pmatrix function.A p-matrix can be created using
the \link[nbpInference]{make.pmatrix} function.}

\item{xi}{a number in the range 0 to 0.5, the cutoff related to the treatment
assignment probability caliper.}
}
\value{
I x 2 dataframe
}
\description{
This function estimates the sample average treatment effect for a set of
matched pairs using the bias-corrected Neyman estimator, defined in \insertCite{frazier2024bias;textual}{nbpInference}.
}
\examples{
set.seed(12345)
X <- rnorm(100, 0, 5)
Z <- X + rnorm(100, 0, (1+sqrt(abs(X))))
Y <- X + Z + rnorm(100, 0, 0.5)
pmat <- make.pmatrix(Z, X)
pairs <- nbp.caliper(Z, X, pmat, xi = 0.1, M = 10000)
bias.corrected.neyman(Y, Z, pairs, pmat, xi = 0.1)
}
\seealso{
Other inference: 
\code{\link{classic.neyman}()},
\code{\link{covAdj.variance}()},
\code{\link{make.pmatrix}()},
\code{\link{nbp.caliper}()}
}
\concept{inference}
