% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{distance}
\alias{distance}
\title{Calculate the distance between two vectors.}
\usage{
distance(x, y, measure)
}
\arguments{
\item{x, y}{Numeric vectors.}

\item{measure}{Distance measure ("euclidean" or "squared_euclidean").}
}
\value{
The distance between \code{x} and \code{y}.
}
\description{
Calculate the distance between two vectors.
}
\details{
Distance measures in this package are based on those defined
in the \href{http://dmg.org/pmml/v4-3/ClusteringModel.html#xsdElement_ComparisonMeasure}{PMML specification}.
Distances are calculated using the following equations:\cr

Euclidean: \eqn{(\sum((x_i - y_i)^2))^0.5}\cr\cr
Squared euclidean: \eqn{\sum((x_i - y_i)^2)}\cr\cr

The input vectors must be of the same length.
}
\examples{
distance(c(-0.5,1),c(0.4,1.6),"euclidean")
distance(c(-0.5,1),c(0.4,1.6),"squared_euclidean")

}
\seealso{
\code{\link{similarity}},
\href{http://dmg.org/pmml/v4-3/ClusteringModel.html#xsdElement_ComparisonMeasure}{PMML comparison measures}
}
