% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shap.R
\name{plot_shap_bar}
\alias{plot_shap_bar}
\title{SHAP importance bar plot}
\usage{
plot_shap_bar(
  shap,
  x,
  sort = TRUE,
  labels = c("Negative", "Positive"),
  top = NULL
)
}
\arguments{
\item{shap}{a matrix of SHAP values}

\item{x}{a matrix or dataframe of feature values containing only features
values from the training data. The rows must match rows in \code{shap}. If a
dataframe is supplied it is converted to a numeric matrix using
\code{\link[=data.matrix]{data.matrix()}}.}

\item{sort}{Logical whether to sort predictors by mean absolute SHAP value}

\item{labels}{Character vector of labels for directionality}

\item{top}{Sets a limit on the number of variables plotted or \code{NULL} to plot
all variables. If \code{top} is set then variables are sorted and \code{sort} is
overrode.}
}
\value{
A ggplot2 plot
}
\description{
SHAP importance bar plot
}
