% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varImp.R
\name{var_stability}
\alias{var_stability}
\alias{var_stability.nestcv.glmnet}
\alias{var_stability.nestcv.train}
\alias{var_stability.repeatcv}
\title{Variable stability}
\usage{
var_stability(x, ...)

\method{var_stability}{nestcv.glmnet}(
  x,
  ranks = FALSE,
  summary = TRUE,
  percent = TRUE,
  level = 1,
  sort = TRUE,
  ...
)

\method{var_stability}{nestcv.train}(x, ranks = FALSE, summary = TRUE, sort = TRUE, ...)

\method{var_stability}{repeatcv}(x, ...)
}
\arguments{
\item{x}{a \code{nestcv.glmnet} or \code{nestcv.train} fitted object or a list of
these, or a \code{repeatcv} object.}

\item{...}{Optional arguments for compatibility}

\item{ranks}{Logical whether to rank variables by importance}

\item{summary}{Logical whether to return summary statistics on variable
importance. Ignored if \code{ranks} is \code{TRUE}.}

\item{percent}{Logical for \code{nestcv.glmnet} objects only, whether to scale
coefficients to percentage of the largest coefficient in each model}

\item{level}{For multinomial \code{nestcv.glmnet} models only, either an integer
specifying which level of outcome is being examined, or the level can be
specified as a character value}

\item{sort}{Logical whether to sort variables by mean importance}
}
\value{
If \code{ranks} is \code{FALSE} and \code{summary} is \code{TRUE}, returns a dataframe
containing mean, sd, sem of variable importance and frequency by which each
variable is selected in outer folds. If \code{summary} is \code{FALSE}, a matrix of
either variable importance or, if \code{ranks = TRUE}, rankings  across the
outer folds and the final model is returned, with variables in rows and
folds in columns.
}
\description{
Uses variable importance across models trained and tested across outer CV
folds to assess stability of variable importance. For glmnet, variable
importance is measured as the absolute model coefficients, optionally scaled
as a percentage. The frequency with which each variable is selected in outer
folds as well as the final model is also returned which is helpful for sparse
models or with filters to determine how often variables end up in the model
in each fold. For glmnet, the direction of effect is taken directly from the
sign of model coefficients. For \code{caret} models, direction of effect is not
readily available, so as a substitute, the directionality of each predictor
is determined by the function \code{\link[=var_direction]{var_direction()}} using the sign of a t-test
for binary classification or the sign of regression coefficient for
continuous outcomes (not available for multiclass caret models). To better
understand direction of effect of each predictor within the final model, we
recommend using SHAP values - see the vignette "Explaining nestedcv models
with Shapley values". See \code{\link[=pred_train]{pred_train()}} for an example.
}
\details{
Note that for caret models \code{\link[caret:varImp]{caret::varImp()}} may require the model package to
be fully loaded in order to function. During the fitting process \code{caret}
often only loads the package by namespace.
}
\seealso{
\code{\link[=cv_coef]{cv_coef()}} \code{\link[=cv_varImp]{cv_varImp()}} \code{\link[=pred_train]{pred_train()}}
}
