% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp.R
\name{performance_profile}
\alias{performance_profile}
\title{Performance profile function}
\usage{
performance_profile(
  data,
  minimize = TRUE,
  logbase = 1,
  legend_title = "",
  xlab = expression(tau),
  ylab = expression(rho),
  xmax = 0,
  colors = c(),
  plot = TRUE,
  xgrid = c()
)
}
\arguments{
\item{data}{data frame with the data}

\item{minimize}{true if lower values mean best performance and false otherwise}

\item{logbase}{base of the logarithm used to represent performance profiles}

\item{legend_title}{title for the legend}

\item{xlab}{x axis label}

\item{ylab}{y axis label}

\item{xmax}{maximum value of xaxis}

\item{colors}{vector with the colors of each configuration}

\item{plot}{bool to display the plot or not}

\item{xgrid}{vector for using it as grid in ratios}
}
\value{
ggplot object with the corresponding performance profile
}
\description{
Function that returns a ggplot object with the corresponding performance profile
}
\examples{
example_data = generate_random_example(seed = 1234)
performance_profile(example_data)

}
