% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathwayRMSE.r
\name{pathwayRMSE}
\alias{pathwayRMSE}
\title{Summary of pathway RMSE}
\usage{
pathwayRMSE(x, maxlen = 2, ...)
}
\arguments{
\item{x}{An object of class "netSEM", the returned list from netSEMm().}

\item{maxlen}{The maximum length of chosen mechanism.}

\item{...}{A S3 generic/method consistency.}
}
\value{
A data frame of result. A summary of RMSE results for all of pathways.
}
\description{
Summarize root mean square error (RMSE) for direct and indirect pathway from netSEMp1 result.
}
\details{
pathwayRMSE gives a summary about RMSE.
}
\examples{
\dontrun{
data(acrylic)
ans <- netSEMp1(acrylic)
pathwayRMSE(ans,maxlen=2)
}
}
\seealso{
\link[netSEM]{netSEMp1}, \link[netSEM]{pathwayPredict}
}
