% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_NM.R
\name{make_NM}
\alias{make_NM}
\title{Make a Niche Model network}
\usage{
make_NM(
  size,
  niches,
  net_kind = "matrix",
  connectance = 0.1,
  directed = TRUE,
  grow = FALSE
)
}
\arguments{
\item{size}{The number of nodes in the network. Must be a positive integer.}

\item{niches}{A vector of numbers specifying the niche of each member of the system (node). Each niche value must be element of [0,1].}

\item{net_kind}{The format of the network. Currently must be either `matrix` or `list`.}

\item{connectance}{Defaults to 0.5. The ratio of actual interactions to possible interactions. Effects the beta distributed width of niche values each member of the system (node) interacts with.}

\item{directed}{If FALSE all interactions will be made symmetric. Note that the process of creating interactions is unaffected by this choice. Defaults to TRUE.}

\item{grow}{Binary argument that determines if the network should be made in a growing fashion, where nodes' edges are added in order of their niches and can only attach to previously considered nodes. Defaults to FALSE.}
}
\value{
An interaction matrix format of a Niche Model network.
}
\description{
Creates a single network according to the Niche Model. Can be directed or undirected, but is always unweighted.
}
\examples{
# Import netcom
library(netcom)

# Network size (number of nodes)
size <- 10

# Create niche values for each member of the system (node)
niches <- stats::runif(n = size)

# Make network according to the Niche Model
make_NM(size = size, niches = niches)

}
\references{
Williams, R. J., & Martinez, N. D. (2000). Simple rules yield complex food webs. Nature, 404(6774), 180-183.
}
