% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_Systematic_directedCanonicalLike.R
\name{make_Systematic_directedCanonicalLike}
\alias{make_Systematic_directedCanonicalLike}
\title{Systematically Make Networks}
\usage{
make_Systematic_directedCanonicalLike(
  net_size,
  directed = TRUE,
  net_kind = "matrix",
  resolution = 100,
  resolution_min = 0.01,
  resolution_max = 0.99,
  reps = 3,
  processes = c("ER", "PA", "DM", "SW", "NM"),
  power_max = 5,
  connectance_max = 0.5,
  divergence_max = 0.5,
  mutation_max = 0.5,
  cores = 1,
  verbose = TRUE
)
}
\arguments{
\item{net_size}{Number of nodes in the network.}

\item{directed}{Whether the target network is directed. Defaults to TRUE.}

\item{net_kind}{If the network is an adjacency matrix ("matrix") or an edge list ("list"). Defaults to "matrix".}

\item{resolution}{The first step is to find the version of each process most similar to the target network. This parameter sets the number of parameter values to search across. Decrease to improve performance, but at the cost of accuracy. Defaults to 100.}

\item{resolution_min}{= The minimum parameter value to consider. Zero is not used because in many processes it results in degenerate systems (e.g. entirely unconnected networks). Currently process agnostic. Future versions will accept a vector of values, one for each process. Defaults to 0.01.}

\item{resolution_max}{The maximum parameter value to consider. One is not used because in many processes it results in degenerate systems (e.g. entirely connected networks). Currently process agnostic. Future versions will accept a vector of values, one for each process. Defaults to 0.99.}

\item{reps}{Defaults to 3. The number of networks to simulate for each parameter. More replicates increases accuracy by making the estimation of the parameter that produces networks most similar to the target network less idiosyncratic.}

\item{processes}{Defaults to c("ER", "PA", "DD", "SW", "NM"). Vector of process abbreviations. Currently only the default five are supported. Future versions will accept user-defined network-generating functions and associated parameters. ER = Erdos-Renyi random. PA = Preferential Attachment. DD = Duplication and Divergence. SW = Small World. NM = Niche Model.}

\item{power_max}{= Defaults to 5. The maximum power of attachment in the Preferential Attachment process (PA).}

\item{connectance_max}{= Defaults to 0.5. The maximum connectance parameter for the Niche Model.}

\item{divergence_max}{= Defaults to 0.5. The maximum divergence parameter for the Duplication and Divergence/Mutation mechanisms.}

\item{mutation_max}{= Defaults to 0.5. The maximum mutation parameter for the Duplication and Mutation mechanism.}

\item{cores}{= Defaults to 1. The number of cores to run the classification on. When set to 1 parallelization will be ignored.}

\item{verbose}{= Defaults to TRUE. Whether to print all messages.}
}
\value{
A list. The first element contains the networks. The second contains their corresponding parameters.
}
\description{
Creates a list of networks that systematically spans mechanisms and their respective parameters.
}
\details{
Produces ground-truthing network data.
}
\examples{
# Import netcom
library(netcom)

make_Systematic(net_size = 10)

}
\references{
Langendorf, R. E., & Burgess, M. G. (2020). Empirically Classifying Network Mechanisms. arXiv preprint arXiv:2012.15863.
}
