% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color-paletts.R
\name{colorRamp2}
\alias{colorRamp2}
\title{A faster implementation of \link[grDevices:colorRamp]{grDevices::colorRamp} for linear interpolation.}
\usage{
colorRamp2(x, alpha = TRUE, thresholds = NULL)
}
\arguments{
\item{x}{A vector of colors.}

\item{alpha}{Logical scalar. When \code{TRUE}
This implementation of \code{colorRamp} can be 2 or more times faster than the \code{grDevices}
version. It is intended for consecutive calls (i.e. in a loop) to improve
performance. It is equivalent to the linear interpolation of the function
\code{colorRamp}.}

\item{thresholds}{A numeric vector of length \code{length(x)}. Optional threshold
levels so that the mixing can be different that even.}
}
\value{
A function as in \link[grDevices:colorRamp]{grDevices::colorRamp}.
}
\description{
A faster implementation of \link[grDevices:colorRamp]{grDevices::colorRamp} for linear interpolation.
}
\examples{

# Creating a function for 2 colors
myf <- colorRamp2(c("black", "steelblue"))
f   <- colorRamp(c("black", "steelblue"))

plot.new()
plot.window(xlim = c(0,2), ylim = c(1, 11))

# These should be the same colors
rect(
  xleft   = 0,
  xright  = 1,
  ybottom = 1:10,
  ytop    = 2:11,
  col = rgb(myf((1:10)/10), maxColorValue = 255)
  )
rect(
  xleft   = 1,
  xright  = 2,
  ybottom = 1:10,
  ytop    = 2:11,
  col = rgb(f((1:10)/10), maxColorValue = 255)
)

# Another example setting different thresholds
myf  <- colorRamp2(c("black", "steelblue"))
myf2 <- colorRamp2(c("black", "steelblue"), thresholds=c(0, .7))

plot.new()
plot.window(xlim = c(0,2), ylim = c(1, 11))

# These should be the same colors
rect(
  xleft   = 0,
  xright  = 1,
  ybottom = 1:10,
  ytop    = 2:11,
  col = rgb(myf((1:10)/10), maxColorValue = 255)
  )
rect(
  xleft   = 1,
  xright  = 2,
  ybottom = 1:10,
  ytop    = 2:11,
  col = rgb(myf2((1:10)/10), maxColorValue = 255)
)



}
