% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_description.R
\docType{data}
\name{interactions}
\alias{interactions}
\title{Social interaction data set}
\format{A data set with four variables. Includes the true parameters.
\describe{
\item{interactions}{25 x 25 x 5 numeric array of directed relations}
	\item{xbinary}{25 x 25 x 5 numeric array of  binary indictors}
	\item{xabs}{25 x 25 x 5 numeric array of standardized absolute difference in indicated interest in each subject area}
	\item{betatrue}{Numeric vector of length 7 that contains true coefficients. The first two (value 1) pertain to \code{shared_project} and \code{grade_difference_abs}. The last three are separate intercepts for each observation of the network.}
	\item{Omegatrue}{3000 x 3000 numeric matrix: the true covariance matrix of the errors.}
	\item{phitrue}{2x6 numeric matrix: true parameters of covariance matrix.}
	}}
\description{
A synthetic data set of standardized, directed interactions between 25 students in a seventh grade class.
}
\details{
We generated a symthetic data set form a true linear model with jointly exchangeable errors. The interactions (the outcomes) between 25 students represent normalized, directed relations between them in 5 different contexts (texts). The observation could be, for instance, the standardized number of characters texted from one student to another over a month pertaining to five subjects: school, friends, family, significant others, and popular culture. The first covariate, \code{xbinary}, indicates whether both students indicated in a survey that they were interested in each topic. The second covariate, \code{xabs}, measures the absolute, standardized difference in number of characters in total texts of each student of each subject area.
}
\examples{
data("interactions")

}
\keyword{datasets}
