% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smi.R
\name{smi}
\alias{smi}
\alias{smi.table}
\alias{smi.igraph}
\alias{smi.default}
\title{Segregation Matrix Index}
\usage{
smi(object, ...)

\method{smi}{table}(object, normalize = TRUE, ...)

\method{smi}{igraph}(object, vattr, ...)

\method{smi}{default}(object, ...)
}
\arguments{
\item{object}{R object, see Details for available methods}

\item{...}{other arguments passed to/from other methods}

\item{normalize}{logical, whether normalized values should be returned,
defaults to \code{TRUE}}

\item{vattr}{character, name of the node attribute designating groups}
}
\value{
Numeric vector of length equal to the number of groups in \code{g}
according to \code{vattr} with the values of SMI for the groups.
}
\description{
Segregation Matrix Index due to Freshtman (1997). A measure of network
segregation. Currently (and originally) supports only two groups.
}
\details{
The Segregation Matrix Index (SMI) is calculated for every group separately.
It compares the density within group to the density of between group ties of
nodes belonging to that group.

Non-normalized version is the ratio of the within-group density to the
between-group density, so vary between 0 and infinity. The normalized
version varies between 0 and 1.

If \code{object} is a table it is interpreted as a mixing matrix.
Two-dimensional table is interpreted as a contact layer. Three-dimensional
table is interpreted as a full mixing matrix \eqn{m_{ghy}}{m[ghy]}
cross-classyfying all dyads, in which \eqn{g} and \eqn{h} correspond to
group membership of ego and alter respectively. Layers \eqn{y=1} and
\eqn{y=2} are assumed to be non-contact and contact layers respectively.

If \code{object} is of class "igraph" it is required to supply \code{vattr}
with the name of the vertex attribute to calculate intermediate mixing
matrix.
}
\examples{
# smi() needs a directed network
smi( igraph::as_directed(WhiteKinship, "mutual"), "gender")
}
\references{
Freshtman, M. (1997) "Cohesive Group Segregation Detection in a
Social Network by the Segregation Matrix Index", Social Networks,
19:193--207
}
\seealso{
Other segregation measures: 
\code{\link{assort}()},
\code{\link{coleman}()},
\code{\link{ei}()},
\code{\link{freeman}()},
\code{\link{gamix}()},
\code{\link{orwg}()},
\code{\link{ssi}()}
}
\concept{segregation measures}
