% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{gen_rand_conn}
\alias{gen_rand_conn}
\title{Generate randomly permuted connectivity matrix}
\usage{
gen_rand_conn(n, K, lambda, gamma = 0.3, pri = rep(1, K)/K, theta = rep(1, n))
}
\arguments{
\item{n}{number of nodes}

\item{K}{number of communities}

\item{lambda}{expected average degree}

\item{gamma}{a measure of out-in-ratio (convex combination parameter)}

\item{pri}{the prior on community labels}

\item{theta}{node connection propensity parameter of DCSBM, by default
E(theta) = 1}
}
\value{
connectivity matrix B of the desired DCSBM.
}
\description{
Creates a randomly permuted DCPP connectivity matrix with a given average
expected degree
}
\details{
The connectivity matrix is a convex combination of a random symmetric
permutation matrix and the matrix of all ones, with weights gamm and 1-gamma.
}
\keyword{models}
