% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/BrainSpace.R
\docType{methods}
\name{bounds}
\alias{bounds}
\alias{bounds,BrainData-method}
\alias{bounds,BrainSpace-method}
\title{Generic function to extract the spatial bounds (origin + dim * spacing) of an image
param x the object}
\usage{
bounds(x)

\S4method{bounds}{BrainSpace}(x)

\S4method{bounds}{BrainData}(x)
}
\arguments{
\item{x}{the object with \code{bounds} property}
}
\value{
a \code{matrix} where each row contains the min (column 1) and max (column 2) bounds of the image dimension from 1 to \code{ndim(image)}.
}
\description{
Generic function to extract the spatial bounds (origin + dim * spacing) of an image
param x the object

bounds
}
\examples{
bspace <- BrainSpace(c(10,10,10), c(2,2,2))
b <- bounds(bspace)
nrow(b) == ndim(bspace)
ncol(b) == 2
}

