% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{neutralitytest}
\alias{neutralitytest}
\title{Testing for neutrality on cancer sequencing data}
\usage{
neutralitytest(
  VAF,
  fmin = 0.1,
  fmax = 0.25,
  read_depth = NULL,
  rho = 0,
  cellularity = 1,
  ploidy = 2
)
}
\arguments{
\item{VAF}{Vector of variant allele frequencies (VAFs) from a deep sequencing experiment,
numbers should be between 0 and 1}

\item{fmin}{Minimum VAF of integration range, default is 0.1}

\item{fmax}{Maximum VAF of integration range, default is 0.25}

\item{read_depth}{Read depth of sample, if this is specified it will be used to calculate an approptiate integration range.
default is NULL in which case the default or inputted fmin and fmax will be used.}

\item{rho}{Overdispersion of sample if known, default is 0.0. Will be used to calculate integration range if read_depth != NULL}

\item{cellularity}{Cellularity of sample, default is 1.0. Will be used to calculate integration range if read_depth != NULL}

\item{ploidy}{Ploidy of the genome, default is 2. Ideally mutations should be filtered for this ploidy before running the test.
Will be used to calculate integration range if read_depth != NULL}
}
\value{
neutralitytest object which contains test statistics which tests
if the sequencing data is consistent a neutral evolutionary model.
Test statistics are area between theoretical and empirical curves, kolmogorov distance, mean distance and R^2 statistics
from linear model fit. Also returns an estimate of the mutation rate per tumour tumour doubling, the raw VAFs and
cumulative distribution
}
\description{
\code{neutralitytest} returns a neutralitytest object which contains the result of
various test statistics to test for neutrality as described in Williams et al. Nature Genetics 2018.
WARNING: This package has been superseded by MOBSTER, see Caravagna et al. Nature Genetics 2020.
}
\examples{
neutralitytest(runif(100))
neutralitytest(VAFselection, fmin = 0.1, fmax = 0.25)
neutralitytest(VAFneutral, read_depth = 100.0, cellularity = 0.8)
}
