\name{compute_all_metrics}
\alias{compute_all_metrics}
\title{Compute Neutrosophic Interval Metrics}
\usage{
compute_all_metrics(data)
}
\arguments{
\item{data}{A data frame containing columns 'Auxili_min', 'Auxili_max',
'Study_min', and 'Study_max'}
}
\value{
A list containing all calculated metrics with components:
\itemize{
  \item mean_interval_X - Mean interval for auxiliary variable (min, max)
  \item subtracted_intervals_X - Data frame of subtracted intervals for auxiliary
  \item sd_interval_X - Standard deviations for auxiliary (min, max)
  \item cv_interval_X - Coefficients of variation for auxiliary (min, max)
  \item kurtosis_interval_X - Kurtosis values for auxiliary (min, max)
  \item mean_interval_Y - Mean interval for study variable (min, max)
  \item subtracted_intervals_Y - Data frame of subtracted intervals for study
  \item sd_interval_Y - Standard deviations for study (min, max)
  \item cv_interval_Y - Coefficients of variation for study (min, max)
  \item correlation_results - Correlation between intervals (rho_L, rho_U)
}
}
\author{
Neha Purwar, Kaustav Aditya, Pankaj Das and Bharti
}

\description{
Calculates various metrics for neutrosophic interval data including means,
standard deviations, CVs, kurtosis, and correlations between interval-valued
variables.
}
\examples{
data(japan_neutro)
metrics <- compute_all_metrics(japan_neutro)

# View mean intervals
cat("Auxiliary Mean Interval:", metrics$mean_interval_X, "\n")
cat("Study Mean Interval:", metrics$mean_interval_Y, "\n")

# View correlation results
cat("Correlation between intervals (rho_L, rho_U):",
    metrics$correlation_results, "\n")
}
