% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplers.R
\name{samplers}
\alias{samplers}
\alias{rpois_network}
\alias{rexp_network}
\alias{rbinom_network}
\alias{rsbm}
\title{Graph samplers using edge distributions}
\usage{
rpois_network(n, num_vertices, lambda = 1)

rexp_network(n, num_vertices, rate = 1)

rbinom_network(n, num_vertices, size = 1, prob = 0.5)

rsbm(n, num_vertices, pref_matrix, block_sizes)
}
\arguments{
\item{n}{Sample size.}

\item{num_vertices}{Number of vertices.}

\item{lambda}{The mean parameter for the Poisson distribution (default: 1).}

\item{rate}{The rate parameter for the exponential distribution (default: 1).}

\item{size}{The number of trials for the binomial distribution (default: 1).}

\item{prob}{The probability of success on each trial for the binomial
distribution (default: 0.5).}

\item{pref_matrix}{The matrix giving the Bernoulli rates. This is a KxK
matrix, where K is the number of groups. The probability of creating an
edge between vertices from groups i and j is given by element (i,j). For
undirected graphs, this matrix must be symmetric. See
\code{\link[igraph]{sample_sbm}}.}

\item{block_sizes}{Numeric vector giving the number of vertices in each
group. The sum of the vector must match the number of vertices. See
\code{\link[igraph]{sample_sbm}}.}
}
\value{
A object of class \code{\link{nvd}} containing the sample of graphs.
}
\description{
A collection of functions to generate random graphs with specified edge
distribution.
}
\examples{
nvd <- rexp_network(10, 68)
}
