% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_headlines.R
\name{get_headlines}
\alias{get_headlines}
\title{Returns selected headlines from newsapi.org}
\usage{
get_headlines(query = NULL, category = NULL, country = NULL,
  sources = NULL, page = 1, page_size = 100,
  api_key = Sys.getenv("NEWS_API_KEY"))
}
\arguments{
\item{query}{Character string that contains the searchterm.}

\item{category}{Character string with the category you want headlines from.}

\item{country}{Character string with the country you want headlines from.}

\item{sources}{Character vector with with IDs of the news outlets 
you want to focus on (e.g., c("usa-today", "spiegel-online")).}

\item{page}{Specifies the page number of your results that is returned. Must 
be numeric. Default is first page. If you want to get all results 
at once, use \code{get_headlines_all} from 'newsanchor'.}

\item{page_size}{The number of articles per page that are returned. 
Maximum is 100 (also default).}

\item{api_key}{Character string with the API key you get from newsapi.org. 
Passing it is compulsory. Alternatively, a function can be 
provided from the global environment (see \code{set_api_key}).}
}
\value{
List with two dataframes:\cr
        1) Data frame with \code{results_df}\cr
        2) Data frame with \code{meta_data}
}
\description{
\code{get_headlines} returns live top and breaking headlines for a country, 
specific category in a country, single source, or multiple sources. You can 
also search with keywords. Articles are sorted by the earliest date 
published first. To automatically download all results, use 
\code{get_headlines_all()}.\cr\cr
Please check that the \code{api_key} is available. You can provide an explicit
definition of the key or use \code{set_api_key()}. \cr\cr
Valid searchterms are provided in the data sets \code{terms_category}, 
\code{terms_country} or \code{terms_sources}.
}
\examples{
\dontrun{
df <- get_headlines(sources = "bbc-news")
df <- get_headlines(query = "sports", page = 2)
df <- get_headlines(category = "business")
}
}
