% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Goalie.R
\name{get_goalie_leaders}
\alias{get_goalie_leaders}
\title{Get goalie statistics leaders by season, game-type, and category}
\usage{
get_goalie_leaders(
  season = get_season_now()$seasonId,
  game_type = 2,
  category = "wins"
)
}
\arguments{
\item{season}{integer in YYYYYYYY}

\item{game_type}{integer where 2=regular and 3=playoffs}

\item{category}{string of 'wins', 'shutouts', 'savePctg', or
'goalsAgainstAverage'}
}
\value{
tibble with one row per goalie
}
\description{
\code{get_goalie_leaders()} retrieves information on each goalie for a given set of \code{season}, \code{game_type}, and \code{category}, including but not limited to their ID, name, and statistics. Access \code{get_seasons()} for \code{season} reference.
}
\examples{
playoff_savePctg_leaders_20242025 <- get_goalie_leaders(
  season=20242025,
  game_type=3,
  category='savePctg'
)
}
