% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localTrapCalculations.R
\name{localTrapCalculations}
\alias{localTrapCalculations}
\alias{makeGrid}
\alias{findLocalTraps}
\alias{getNumLocalTraps}
\alias{getLocalTrapIndices}
\alias{calcLocalTrapDists}
\alias{calcLocalTrapExposure}
\title{Local Trap Calculations}
\usage{
makeGrid(xmin = 0, ymin = 0, xmax, ymax, resolution = 1, buffer = 0)

findLocalTraps(grid, trapCoords, dmax)

getNumLocalTraps(idarg, nLocalTraps, LTD1arg)

getLocalTrapIndices(MAXNUM, localTraps, n, idarg)

calcLocalTrapDists(MAXNUM, n, localTrapInd, s, trapCoords)

calcLocalTrapExposure(R, n, d, localTrapInd, sigma, p0)
}
\arguments{
\item{xmin}{Minimal value among all trap location x-coordinates.}

\item{ymin}{Minimal value among all trap location y-coordinates.}

\item{xmax}{Maximal value among all trap location x-coordinates.}

\item{ymax}{Maximal value among all trap location y-coordinates.}

\item{resolution}{Desired resolution (in both x and y directions) of discretized grid.}

\item{buffer}{Horizontal and vertical buffer for discretized grid, specifying how much it should extend (above, below, left, and right) of the maximal trap locations.}

\item{grid}{The grid object returned from the makeGrid function.}

\item{trapCoords}{An nTraps x 2 array giving giving the x- and y-coordinate locations of all traps.}

\item{dmax}{The maximal radius from an activity center for performing trap calculations (dmax).}

\item{idarg}{A grid id, returned from the makeID function inside model code.}

\item{nLocalTraps}{The number of local traps to all grid cells, which is given by the first column of the localTraps array.}

\item{LTD1arg}{The number of columns in the localTraps array.}

\item{MAXNUM}{The maximum number of local traps among all grid cells.  This is given by the (number of rows)-1 of the localTraps array.}

\item{localTraps}{The array returned from the findLocalTraps function.}

\item{n}{The number of local traps to a specified grid cell, as return.}

\item{localTrapInd}{The indices of the local traps to a grid cell, as returned by the getLocalTrapIndices function.}

\item{s}{A length-2 vector giving the activity center of an indiviual.}

\item{R}{The total number of traps.}

\item{d}{A vector of distances from an activity center to the local traps.}

\item{sigma}{Scale of decay for detection probability.}

\item{p0}{Baseline detection probability.}
}
\description{
These functions are deprecated, and they will be removed from a future release.  Utility functions to enable local trap calculations in SCR models.  See details section for more information.
}
\details{
These functions are deprecated, and they will be removed from a future release.

The makeGrid function is used in advance of model building.  It creates and returns a list of two objects: a table (grid) corresponding to the discretized grid, where each row gives the x-coordinate, the y-coordinate, and the id number for a grid cell; and second, a function (makeID) to be used in the model code which operates on a discretized AC location, and returns the id number of the corresponding grid cell.

The findLocalTraps function operates on the grid object returned from makeGrid, and an array of the trap location coordinates, and the desired maximal exposure radius for caluclations (dmax).  It returns a array (localTraps) with number of rows equal to the number of grid cells.  The first element of each row gives the number of local traps within exposure radius to that grid cell.  The following elements of each row give the id numbers of those local traps.

A visualization function (plotTraps) is also provided in the example code, which displaces the discretized grid (small black points), all trap locations (green circles), a specified grid cell location (specified by i) as a large X, and the local traps to that specified grid cell (red circles).

The getNumLocalTraps function is used inside the model code.  It operates on an id for a grid cell, the localTraps array (generated by findLocalTraps), and the constant value LTD1.  This function returns the number of traps which are local to a specified grid cell.

The getLocalTrapIndices function is used inside the model code.  It returns a vector containing the ids of the local traps to a particular grid cell.

The calcLocalTrapDists function is used inside the model code.  It calculates the distances from an activity center, to the local traps relative to the grid cell nearest that activity center.

The calcLocalTrapExposure function is specific to the detection probability calculations used in this example.  This function should be modified specifically to the detection function, exposure function, or otherwise calculations to be done only for the traps in the vicinity of individual activity center locations
}
\examples{

\dontrun{

## generate random trap locations
nTraps <- 200
traps_xmin <- 0
traps_ymin <- 0
traps_xmax <- 100
traps_ymax <- 200
set.seed(0)
traps_xCoords <- round(runif(nTraps, traps_xmin, traps_xmax))
traps_yCoords <- round(runif(nTraps, traps_ymin, traps_ymax))
trap_coords <- cbind(traps_xCoords, traps_yCoords)
 
## buffer distance surrounding sides of rectangular discretization grid
## which overlays trap locations
buffer <- 10
 
## resolution of rectangular discretization grid
resolution <- 10
 
## creates grid and makeID function,
## for grid overlaying trap locations,
## and to lookup nearest grid cell to any AC
makeGridReturn <- makeGrid(xmin = traps_xmin, xmax = traps_xmax,
                           ymin = traps_ymin, ymax = traps_ymax,
                           buffer = buffer,
                           resolution = resolution)
 
grid <- makeGridReturn$grid
makeID <- makeGridReturn$makeID
 
## maximum radis within an individual AC to perform trap calculations,
dmax <- 30
 
## n = localTraps[i,1] gives the number of local traps
## localTraps[i, 2:(n+1)] gives the indices of the local traps
localTraps <- findLocalTraps(grid, trap_coords, dmax)
 
plotTraps <- function(i, grid, trap_coords, localTraps) {
    plot(grid[,1], grid[,2], pch = '.', cex=2)
    points(trap_coords[,1], trap_coords[,2], pch=20, col='forestgreen', cex=1)
    if(!missing(i)) {
        i <- max(i \%\% dim(grid)[1], 1)
        n <- localTraps[i,1]
        trapInd <- numeric(0)
        if(n > 0)  trapInd <- localTraps[i,2:(n+1)]
        theseTraps <- trap_coords[trapInd,, drop = FALSE]
        points(theseTraps[,1], theseTraps[,2], pch = 20, col = 'red', cex=1.5)
        points(grid[i,1], grid[i,2], pch = 'x', col = 'blue', cex=3)
    }
}
 
## visualise some local traps
plotTraps(10,  grid, trap_coords, localTraps)
plotTraps(200, grid, trap_coords, localTraps)
plotTraps(380, grid, trap_coords, localTraps)
 
## example model code
## using local trap calculations
code <- nimbleCode({
    sigma ~ dunif(0, 100)
    p0 ~ dunif(0, 1)
    for(i in 1:N) {
        S[i,1] ~ dunif(0, xmax)
        S[i,2] ~ dunif(0, ymax)
        Sdiscrete[i,1] <- round(S[i,1]/res) * res
        Sdiscrete[i,2] <- round(S[i,2]/res) * res
        id[i] <- makeID( Sdiscrete[i,1:2] )
        nLocalTraps[i] <- getNumLocalTraps(id[i], localTraps[1:LTD1,1], LTD1)
        localTrapIndices[i,1:maxTraps] <-
            getLocalTrapIndices(maxTraps, localTraps[1:LTD1,1:LTD2], nLocalTraps[i], id[i])
        d[i, 1:maxTraps] <- calcLocalTrapDists(
            maxTraps, nLocalTraps[i], localTrapIndices[i,1:maxTraps],
            S[i,1:2], trap_coords[1:nTraps,1:2])
        g[i, 1:nTraps] <- calcLocalTrapExposure(
            nTraps, nLocalTraps[i], d[i,1:maxTraps], localTrapIndices[i,1:maxTraps], sigma, p0)
        y[i, 1:nTraps] ~ dbinom_vector(prob = g[i,1:nTraps], size = trials[1:nTraps])
    }
})
 
## generate random detection data; completely random
N <- 100
set.seed(0)
y <- array(rbinom(N*nTraps, size=1, prob=0.8), c(N, nTraps))
 
## generate AC location initial values
Sinit <- cbind(runif(N, traps_xmin, traps_xmax),
               runif(N, traps_ymin, traps_ymax))
 
constants <- list(N = N,
                  nTraps = nTraps,
                  trap_coords = trap_coords,
                  xmax = traps_xmax,
                  ymax = traps_ymax,
                  res = resolution,
                  localTraps = localTraps,
                  LTD1 = dim(localTraps)[1],
                  LTD2 = dim(localTraps)[2],
                  maxTraps = dim(localTraps)[2] - 1)
 
data <- list(y = y, trials = rep(1,nTraps))
 
inits <- list(sigma = 1,
              p0 = 0.5,
              S = Sinit)
 
## create NIMBLE model object
Rmodel <- nimbleModel(code, constants, data, inits,
                      calculate = FALSE, check = FALSE)
 
## use model object for MCMC, etc.

}

}
\author{
Daniel Turek
}
