% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/greensIndex.R
\name{greensIndex}
\alias{greensIndex}
\title{Green's Index of Dispersion}
\usage{
greensIndex(data, psu, case, replicates = 999)
}
\arguments{
\item{data}{Survey dataset (as an R data.frame)}

\item{psu}{Name of variable holding PSU (cluster) data as a character
vector of length = 1 (e.g. \code{psu})}

\item{case}{Name of variable holding case status as a character vector of
length = 1 (e.g. \emph{GAM}). The function assumes that case status is
coded with 1 = case}

\item{replicates}{Number of bootstrap replicates (default is 9999)}
}
\value{
A list of class \code{GI} with names:\tabular{ll}{
   \strong{Variable} \tab \strong{Description} \cr
   \emph{GI} \tab Estimate of Green's index \cr
   \emph{LCL} \tab 95\\\% LCL for GI \cr
   \emph{UCL} \tab 95\\\% UCL for GI \cr
   \emph{minGI} \tab Minimum possible GI (maximum uniformity) for the data \cr
   \emph{p} \tab \code{p-value} (H0: = Random distribution of cases across PSUs) \cr
}
}
\description{
Implementation of the Green's Index of Dispersion by bootstrap. The sampling
distribution of the Green's Index is not well described hence bootstrapping
is used to test whether the distribution of cases across primary sampling
units is random.
}
\details{
The value of Green's Index can range between \code{-1/(n - 1)} for maximum
uniformity (specific to the dataset) and one for maximum clumping. The
interpretation of Green’s Index is straightforward:\tabular{ll}{
   \strong{Green's Index Value} \tab \strong{Interpretation} \cr
   \emph{Green's Index close to 0} \tab Random \cr
   \emph{Green's Index greater than 0} \tab Clumped (i.e. more clumped than random) \cr
   \emph{Green’s Index less than 0} \tab Uniform (i.e. more uniform than random) \cr
}
}
\examples{
# Apply Green's Index using anthropometric data from a SMART survey in Sudan
# (flag.ex01)
svy <- flag.ex01
svy$flag <- 0
svy$flag <- ifelse(!is.na(svy$haz) & (svy$haz < -6 | svy$haz > 6),
                   svy$flag + 1, svy$flag)
svy$flag <- ifelse(!is.na(svy$whz) & (svy$whz < -5 | svy$whz > 5),
                   svy$flag + 2, svy$flag)
svy$flag <- ifelse(!is.na(svy$waz) & (svy$waz < -6 | svy$waz > 5),
                   svy$flag + 4, svy$flag)
svy <- svy[svy$flag == 0, ]
svy$stunted <- ifelse(svy$haz < -2, 1, 2)

## set seed to 0 to replicate results
set.seed(0)
greensIndex(data = svy, psu = "psu", case = "stunted")

}
