% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nisra_data_portal.R
\name{nisra_search}
\alias{nisra_search}
\title{Search for a NISRA dataset}
\usage{
nisra_search(
  keyword = NULL,
  regex = NULL,
  dataset_code = NULL,
  variables = NULL,
  datefrom = NULL,
  flush_cache = FALSE
)
}
\arguments{
\item{keyword}{Text to search for in dataset titles}

\item{regex}{Regular expression for searching dataset titles}

\item{dataset_code}{Dataset to find}

\item{variables}{Variables to search for in datasets}

\item{datefrom}{Date to search from. Search is limited to datasets updated in
the last three months if not specified.}

\item{flush_cache}{Ignore cached values}
}
\value{
A tibble of dataset information matching the search
terms. This will include dataset codes, label, frequency, dimensions,
and dimensions.
}
\description{
Search the NISRA data portal for a dataset. You can search dataset titles
either for a keyword or with a regular expression, using a dataset code, or
by variables that appear in dataset. You can also specify how recently the
dataset must have been updated.
}
\examples{
population_datasets <- nisra_search(keyword = "population")
age_datasets <- nisra_search(variables = "age")
}
