% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_hf.R
\name{get_hf}
\alias{get_hf}
\title{Estimate half-life from pooled pharmacokinetic data}
\usage{
get_hf(dat, dose_type = "first_dose", pooled = NULL, verbose = TRUE, ...)
}
\arguments{
\item{dat}{A data frame containing raw time–concentration data in the
standard nlmixr2 format.}

\item{dose_type}{Specifies the dosing context of the pharmacokinetic
observations. Classified as:
\itemize{
\item first_dose: observations occur only after the initial administration
\item repeated_doses: observations occur only after multiple
administrations or at steady state
\item combined_doses: observations include both first-dose and
repeated-dose intervals
}}

\item{pooled}{Optional pooled data object generated by get_pooled_data. If
not provided, pooled data are automatically created using the input dataset.}

\item{verbose}{Logical; if TRUE (default), progress and completion
messages are printed to the console. Set to FALSE to suppress all
informational messages, for example when running automated scripts or tests.}

\item{...}{Additional arguments passed to bin.time for pooling operations or
to find_best_lambdaz for elimination slope estimation.}
}
\value{
A list containing individual and median half-life estimates for
first-dose, repeated-dose, and combined dosing profiles.
}
\description{
Estimates the terminal half-life of a drug using pooled pharmacokinetic data.
The method supports analysis based on first-dose, repeated-dose, or combined
dosing profiles.
}
\details{
The function estimates terminal half-life using the following procedure:
\itemize{
\item Generate or use existing pooled pharmacokinetic data
\item Identify the terminal phase using elimination slope estimation
\item Calculate the terminal elimination rate constant (lambda_z)
\item Derive half-life using:
}

\deqn{
  t_{1/2} = \frac{\log(2)}{\lambda_z}
}
}
\examples{
dat <- Bolus_1CPT
dat <- processData(dat)$dat
get_hf(dat, dose_type = "combined_doses")

}
\seealso{
\link{get_pooled_data}, \link{bin.time}, \link{find_best_lambdaz}
}
\author{
Zhonghui Huang
}
