% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.nlmixr2.R
\name{plot.nlmixr2FitData}
\alias{plot.nlmixr2FitData}
\title{Plot a nlmixr2 data object}
\usage{
\method{plot}{nlmixr2FitData}(x, ...)
}
\arguments{
\item{x}{a focei fit object}

\item{...}{additional arguments (currently ignored)}
}
\value{
An \code{nlmixr2PlotList} object (a list of ggplot2 objects with easier
plotting for all of them at the same time)
}
\description{
Plot some standard goodness of fit plots for the focei fitted object
}
\examples{
\donttest{
library(nlmixr2est)
one.compartment <- function() {
  ini({
    tka <- 0.45
    tcl <- 1
    tv <- 3.45
    eta.ka ~ 0.6
    eta.cl ~ 0.3
    eta.v ~ 0.1
    add.sd <- 0.7
  })
  model({
    ka <- exp(tka + eta.ka)
    cl <- exp(tcl + eta.cl)
    v <- exp(tv + eta.v)
    d/dt(depot) = -ka * depot
    d/dt(center) = ka * depot - cl / v * center
    cp = center / v
    cp ~ add(add.sd)
  })
}

## The fit is performed by the function nlmixr/nlmix2 specifying the model, data and estimate
fit <- nlmixr2(one.compartment, theo_sd,  est="saem", saemControl(print=0, nBurn = 10, nEm = 20))

# This shows many goodness of fit plots
plot(fit)
}
}
\author{
Wenping Wang & Matthew Fidler
}
