% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cooc.R
\name{build_df_cooc}
\alias{build_df_cooc}
\title{Compute monthly co-occurrence matrix}
\usage{
build_df_cooc(
  df_ehr,
  uniq_codes = NULL,
  n_cores = 1,
  min_code_freq = 5,
  gc_before_parallel = TRUE
)
}
\arguments{
\item{df_ehr}{Input data frame, monthly counts with columns Patient, Month,
Parent_Code, Count}

\item{uniq_codes}{Not required, useful for sql_cooc function}

\item{n_cores}{Number of cores}

\item{min_code_freq}{Filter matrix based on feature frequency}

\item{gc_before_parallel}{Call garbage collector before computation}
}
\value{
Co-occurrence sparse matrix
}
\description{
Compute monthly co-occurrence matrix
}
\examples{

df_ehr = data.frame(Month = c(1, 1, 1, 2, 2, 3, 3, 4, 4),
                    Patient = c(1, 1, 2, 1, 2, 1, 1, 3, 4),
                    Parent_Code = c('C1', 'C2', 'C2', 'C1', 'C1', 'C1', 'C2',
                                    'C3', 'C4'),
                    Count = 1:9)

spm_cooc = build_df_cooc(df_ehr)

}
