% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSprofd.R
\name{SSprofd}
\alias{SSprofd}
\alias{profd}
\title{self start for profile decay function}
\usage{
profd(x, a, b, c, d)

SSprofd(x, a, b, c, d)
}
\arguments{
\item{x}{input vector (x)}

\item{a}{represents the maximum value}

\item{b}{represents the minimum value}

\item{c}{represents the rate of decay}

\item{d}{represents an empirical coefficient which provides flexibility}
}
\value{
a numeric vector of the same length as x containing parameter estimates for equation specified

profd: vector of the same length as x using the profd function
}
\description{
Self starter for a decay of a variable within a canopy (e.g. nitrogen concentration).
}
\details{
This function is described in Archontoulis and Miguez (2015) - \doi{10.2134/agronj2012.0506} and originally in Johnson et al. (2010) Annals of Botany 106: 735–749, 2010. \doi{10.1093/aob/mcq183}.
}
\examples{
\donttest{
require(ggplot2)
set.seed(1234)
x <- 1:10
y <- profd(x, 0.3, 0.05, 0.5, 4) + rnorm(10, 0, 0.01)
dat <- data.frame(x = x, y = y)
fit <- nls(y ~ SSprofd(x, a, b, c, d), data = dat)
## plot
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
## profiling
## It does not work at a lower alphamax level
## Use this if you want to look at all four parameters
## par(mfrow=c(2,2))
plot(profile(fit, alphamax = 0.016))
## Reset graphical parameter as appropriate: par(mfrow=c(1,1))
## parameter 'd' is not well constrained
confint(fit, level = 0.9)
}

}
