% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nma_thresh.R
\name{get.int}
\alias{get.int}
\title{Get thresholds from U matrix}
\usage{
get.int(
  x,
  kstar,
  trt.code,
  contrs,
  mcid = FALSE,
  mean.dk = NULL,
  inflmat = NULL,
  opt.max = NULL
)
}
\arguments{
\item{x}{Column of \eqn{U} matrix, containing all possible threshold
solutions for a data point.}

\item{kstar}{Base-case optimal treatment.}

\item{trt.code}{Vector of (possibly recoded) treatments. See
\code{nma_thresh} parameter of the same name.}

\item{contrs}{Details of contrasts corresponding to rows in \code{x},
as rows of the data.frame output by \code{d_i2ab}.}

\item{mcid}{Use MCID decision rule? Default \code{FALSE}.}

\item{mean.dk}{Posterior means of basic treatment parameters, required when
\code{mcid} is \code{TRUE}.}

\item{inflmat}{Column of influence matrix \eqn{H} for the data point,
required when \code{mcid} is \code{TRUE}.}

\item{opt.max}{Is the maximum treatment effect optimal? See
\code{nma_thresh} parameter of same name. Required when \code{mcid} is
\code{TRUE}.}
}
\value{
Data frame of thresholds and new optimal treatments with columns
  \code{lo}, \code{lo.newkstar}, \code{hi}, and \code{hi.newkstar}.
}
\description{
Return the positive and negative thresholds for an observation, given a
vector of possible threshold solutions. This function is intended for
internal use, and is called by \code{nma_thresh} automatically.
}
