% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-functions_processing.R
\name{nmr_assign_bins}
\alias{nmr_assign_bins}
\title{Assign compound classes using the chosen binset}
\usage{
nmr_assign_bins(dat, binset)
}
\arguments{
\item{dat}{Input dataframe. This could be spectral data, or peak picked data.
Must include a `ppm` column for compound class assignment}

\item{binset}{A binset; e.g. \code{\link{bins_Clemente2012}},
\code{\link{bins_Hertkorn2013}}, etc., or a similarly-structured data frame}
}
\value{
The input data with a new \code{group} column whose entries
are drawn from the binset. Entries will be \code{NA} if a \code{ppm}
value does not fall into any group.
}
\description{
Assign group (bin name) to each row of the data based on
the \code{ppm} column.
}
\examples{
sdir <- system.file("extdata", "kfp_hysteresis", "spectra_mnova", package = "nmrrr")
spec <- nmr_import_spectra(path = sdir, method = "mnova")
nmr_assign_bins(spec, bins_Clemente2012)
}
\author{
Kaizad Patel
}
