% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Prd.R
\name{Prd}
\alias{Prd}
\title{Prd}
\usage{
Prd(q, eps)
}
\arguments{
\item{q}{a real number in \eqn{(2,\infty)}. Accuracy as well as computation
time increases as \eqn{q} gets closer to \eqn{2} increases}

\item{eps}{a real number in \eqn{(0,\infty)}. ccuracy as well as computation
time increases as \eqn{\varepsilon} gets closer to \eqn{0} increases}
}
\value{
A neural network that takes in \eqn{x} and \eqn{y} and approximately
returns \eqn{xy} when instantiated with ReLU activation, and given a list
c(x,y), the two numbers to be multiplied.

\emph{Note that this must be instantiated with a tuple c(x,y)}
}
\description{
A function that returns the \eqn{\mathsf{Prd}} neural networks that
approximates the product of two real numbers when given an appropriate
\eqn{q}, \eqn{\varepsilon}, a real number \eqn{x} and instantiation with ReLU.
activation.
}
\examples{
Prd(2.1, 0.1) |> inst(ReLU, c(4, 5)) # This may take some time, please only click once

}
\references{
Proposition 3.5. Grohs, P., Hornung, F., Jentzen, A. et al. Space-time error estimates for deep
neural network approximations for differential equations. (2019).
\url{https://arxiv.org/abs/1908.03833}

Definition 2.25. Rafi S., Padgett, J.L., Nakarmi, U. (2024)
Towards an Algebraic Framework For
Approximating Functions Using Neural Network Polynomials
\url{https://arxiv.org/abs/2402.01058}
}
