
<!-- README.md is generated from README.Rmd. Please edit that file -->

# nncc

<!-- badges: start -->
<!-- badges: end -->

## About

The `nncc` package is an R package that provides a tool to implement
nearest-neighbors matching for case-control data. Nearest-neighbors
matching may improve confounding control if case-control data include
too many exposures to control in a logistic regression model.

## Project Admin

Beau B. Bruce, MD, PhD <lue7@cdc.gov>; CDC/NCEZID/DFWED/EDEB

## Installation

``` r
# Install nncc from CRAN
install.packages("nncc")

# Or the development version from GitHub
devtools::install_github("bbbruce/nncc")
```

## Vignettes

If you have installed the `nncc` package, use `vignette("nncc")` or
`browseVignettes("nncc")`.

Otherwise, refer to
<https://CRAN.R-project.org/package=nncc/vignettes/nncc.html>.

## General disclaimer

This repository was created for use by CDC programs to collaborate on
public health related projects in support of the [CDC
mission](https://www.cdc.gov/about/organization/mission.htm). GitHub is
not hosted by the CDC, but is a third party website used by CDC and its
partners to share information and collaborate on software. CDC use of
GitHub does not imply an endorsement of any one particular service,
product, or enterprise.

## License Standard Notice

This repository bundles code licensed under the terms of the GNU General
Public License v3.0, which can be found at
<https://www.gnu.org/licenses/gpl-3.0.en.html>, and therefore is
licensed under GPL v3.0 or later.

The source code in this repository is free: you can redistribute it
and/or modify it under the terms of the GNU General Public License v3.0
or (at your option) any later version.

This source code in this repository is distributed in the hope that it
will be useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

The source code forked from this project will inherit its license.

## Privacy Standard Notice

This repository contains only non-sensitive, publicly available data and
information. All material and community participation is covered by the
[Disclaimer](https://github.com/CDCgov/template/blob/master/DISCLAIMER.md)
and [Code of
Conduct](https://github.com/CDCgov/template/blob/master/code-of-conduct.md).
For more information about CDC’s privacy policy, please visit
<https://www.cdc.gov/other/privacy.html>.

## Contributing Standard Notice

Anyone is encouraged to contribute to the repository by
[forking](https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/working-with-forks/fork-a-repo)
and submitting a pull request. (If you are new to GitHub, you might
start with a [basic
tutorial](https://docs.github.com/en/get-started/quickstart/set-up-git)).
By contributing to this project, you grant a world-wide, royalty-free,
perpetual, irrevocable, non-exclusive, transferable license to all users
under the terms of the [Apache Software License
v2](https://www.apache.org/licenses/LICENSE-2.0.html) or later.

All comments, messages, pull requests, and other submissions received
through CDC including this GitHub page may be subject to applicable
federal law, including but not limited to the Federal Records Act, and
may be archived. Learn more at <https://www.cdc.gov/other/privacy.html>.

## Records Management Standard Notice

This repository is not a source of government records, but is a copy to
increase collaboration and collaborative potential. All government
records will be published through the [CDC web
site](https://www.cdc.gov).

## Additional Standard Notices

Please refer to [CDC’s Template
Repository](https://github.com/CDCgov/template) for more information
about [contributing to this
repository](https://github.com/CDCgov/template/blob/master/CONTRIBUTING.md),
[public domain notices and
disclaimers](https://github.com/CDCgov/template/blob/master/DISCLAIMER.md),
and [code of
conduct](https://github.com/CDCgov/template/blob/master/code-of-conduct.md).
