% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nndiagram_oversize.R
\name{nndiagram_oversize}
\alias{nndiagram_oversize}
\title{Producing 'LaTeX' Code for Drawing Over-sized Neural Network Diagrams}
\usage{
nndiagram_oversize(
  input,
  hidden,
  size.cutoff = 7,
  title = NULL,
  color = "black",
  alpha = 1,
  layer.sep = 2.5,
  layer.label = NULL,
  input.label = NULL,
  output.label = NULL,
  suppress = FALSE
)
}
\arguments{
\item{input}{a positive integer that specifies the number of input neurons.}

\item{hidden}{a positive integer vector that specifies the number of neurons on each hidden layer. For example, c(6,6,6) specifies that there are 3 hidden layers and 6 neurons on each hidden layer. Non-positive and non-integer numbers are not allowed.}

\item{size.cutoff}{an optional numeric value that specifies the cutoff number of neurons. If the number of neurons on a certain layer is greater than this cutoff value, it is considered as an over-sized layer, which will be drawn with some neurons left out.
Otherwise, all neurons on the layer will be drawn. In \code{nndiagram_oversize}, the cutoff number is defined to be no less than \code{5}. Default is \code{7}.}

\item{title}{an optional character that specifies the main title of diagram. Default is \code{NULL}.}

\item{color}{an optional character that specifies the color of lines. Default is \code{"black"}.}

\item{alpha}{an optional numeric value between 0 and 1 that specifies the opacity of lines. \code{1} indicates lines to be opaque, and \code{0} indicates lines to be transparent. Default is \code{1}.}

\item{layer.sep}{an optional positive numeric value that specifies the distance between layers of a neural network. Default is \code{2.5}.}

\item{layer.label}{an optional character vector that specifies label for each layer, including input, hidden and output layers.}

\item{input.label}{an optional character vector that specifies label for each input neuron.}

\item{output.label}{an optional character that specifies label for output neuron.}

\item{suppress}{an optional logical value that specifies whether \code{nndiagram_oversize} should suppress the output of 'LaTeX' code to be directly printed on console. Default is \code{FALSE}.}
}
\value{
\code{nndiagram_oversize} uses \code{cat()} to print out 'LaTeX' code on console, if not suppressed. Also, \code{nndiagram_oversize} saves the same output as a character vector invisibly, so users could use \code{cat()} to print it out later at their demand, as shown in Examples.
The \code{nndiagram_oversize} 'LaTeX' output can be directly copied and pasted to produce neural network diagram in any 'LaTeX' editor.
}
\description{
The \code{nndiagram_oversize} command is used to produce 'LaTeX' code for drawing well-formatted neural network diagrams, some layers of which have excess neurons that users hope to leave out. To make the code work in a 'LaTeX' editor, users need
to install and import the 'TeX' package \href{https://www.overleaf.com/learn/latex/TikZ_package}{TikZ} in the setting of 'TeX' file. Syntax of importing this package is included in the output of function.
}
\note{
This package is an ongoing project, and more functions will be added in the future, such as those to produce pdf version of diagrams or convert handdrawing neural network diagrams to computerized ones. Collaborations are sincerely welcome.
Comments and suggestions are always highly appreciated.
}
\examples{
# A neural network with 3 neurons on input layer, 6 neurons on each of 3 hidden layers, and 1 neuron
# on output layer. All other arguments are default, so no layer is considered to be over-sized.
nndiagram_oversize(input=3, hidden=c(6,6,6))

# Same as the first example but cutoff value of size is designed to be 5, so all hidden layers are
# considered to be over-sized.
nndiagram_oversize(input=3, hidden=c(6,6,6), size.cutoff=5)

# Same as the second example but labels of input neurons are designed to be letters from a to c.
nndiagram_oversize(input=3, hidden=c(6,6,6), size.cutoff=5, input.label=letters[1:3])

# Suppress the output of 'LaTeX' code to be directly printed on the console and save the output
# to an object, which can be printed later at demand.
nnd_oversize <- nndiagram_oversize(input=3, hidden=c(6,6,6), size.cutoff=5, suppress=TRUE)
cat(paste(nnd_oversize,"\n"))
}
\seealso{
\link{nndiagram}; \link{nndiagram_nodeCoverup}; \link{activation_curve}.
}
\author{
Chencheng Fang, Bonn Graduate School of Economics, University of Bonn. Email: \email{ccfang@uni-bonn.de}
}
