% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{funsNNclass.spec}
\alias{funsNNclass.spec}
\alias{NN.class.spec.ct}
\alias{NN.class.spec}
\title{NN Class-specific Chi-square Tests based on NNCTs}
\usage{
NN.class.spec.ct(ct, covN, byrow = TRUE)

NN.class.spec(dat, lab, ...)
}
\arguments{
\item{ct}{A nearest neighbor contingency table, used in \code{NN.class.spec.ct} only}

\item{covN}{The \eqn{k^2 \times k^2} covariance matrix of column-wise vectorized entries of NNCT, \code{ct};
used in \code{NN.class.spec.ct} only.}

\item{byrow}{A logical argument (default=\code{TRUE}). If \code{TRUE}, rows of \code{ct} are appended to obtain the vector
of \eqn{N_{ij}} values and \code{covN} is the covariance matrix for this vector and if \code{FALSE} columns of \code{ct} are appended 
to obtain the \eqn{N_{ij}} vector and \code{covN} is converted to the row-wise version by covNrow2col function;used in \code{NN.class.spec.ct} only.}

\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point,
used in \code{NN.class.spec} only}

\item{lab}{The \code{vector} of class labels (numerical or categorical), used in \code{NN.class.spec} only}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function. 
used in \code{NN.class.spec} only}
}
\value{
A \code{list} with the elements
\item{type}{Type of the class-specific test, which is \code{"NN"} for this function}
\item{statistic}{The \code{vector} of NN class-specific test statistics}
\item{stat.names}{Name of the test statistics}
\item{p.value}{The \code{vector} of \eqn{p}-values for the hypothesis test}
\item{df}{Degrees of freedom for the chi-squared test, which is \eqn{k} for this function.}
\item{estimate}{Estimates of the parameters, transpose of the NNCT, i.e., transpose of the matrix of the 
observed \eqn{N_{ij}} values which is the transpose of NNCT.}
\item{null.value}{Transpose of the matrix of hypothesized null values for the parameters which are expected
values of the \eqn{N_{ij}} values in the NNCT.}
\item{null.name}{Name of the null values}
\item{method}{Description of the hypothesis test}
\item{ct.name}{Name of the contingency table, \code{ct}, returned by \code{NN.class.spec.ct} only}
\item{data.name}{Name of the data set, \code{dat}, returned by \code{NN.class.spec} only}
}
\description{
Two functions: \code{NN.class.spec.ct} and \code{NN.class.spec}.

Both functions are objects of class \code{"classhtest"} but with different arguments (see the parameter list below).
Each one performs class specific segregation tests for the columns, i.e., NN categories for \eqn{k \ge 2} classes.
That is,
each one performs hypothesis tests of deviations of 
entries in each column of NNCT from the expected values under RL or CSR for each column. 
Recall that column labels in the NNCT are NN class labels.
The test for each column \eqn{i} is based on the chi-squared approximation of the corresponding quadratic form
and are due to \insertCite{ceyhan:stat-neer-class2009;textual}{nnspat}.

The argument \code{covN} must be covariance of column-wise vectorization of NNCT if the logical argument \code{byrow=FALSE}
otherwise the function converts \code{covN} (which is done row-wise) to columnwise version with \code{\link{covNrow2col}}
function.

Each function yields the test statistic, \eqn{p}-value and \code{df} for each base class \eqn{i}, description of the 
alternative with the corresponding null values (i.e., expected values) for the column \eqn{i}, estimates for the entries in column \eqn{i}
for \eqn{i=1,\ldots,k}. The functions also provide names of the test statistics, the description of the test and the data set used.

The null hypothesis for each column is that the corresponding \eqn{N_{ij}} entries in column \eqn{i} are equal to their 
expected values under RL or CSR.

See also (\insertCite{dixon:NNCTEco2002,ceyhan:stat-neer-class2009;textual}{nnspat})
and the references therein.
}
\examples{
n<-20
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covNrow<-cov.nnct(ct,varN,Qv,Rv)
covNcol<-covNrow2col(covNrow)

NN.class.spec(Y,cls)
NN.class.spec(Y,cls,method="max")

NN.class.spec.ct(ct,covNrow)
NN.class.spec.ct(ct,covNcol,byrow = FALSE)

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-nnct(ipd,fcls)

NN.class.spec(Y,fcls)
NN.class.spec.ct(ct,covNrow)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covNrow<-cov.nnct(ct,varN,Qv,Rv)
covNcol<-covNrow2col(covNrow)

NN.class.spec(Y,cls)

NN.class.spec.ct(ct,covNrow)
NN.class.spec.ct(ct,covNcol,byrow = FALSE)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{base.class.spec.ct}}, \code{\link{base.class.spec}}, \code{\link{class.spec.ct}} 
and \code{\link{class.spec}}
}
\author{
Elvan Ceyhan
}
