% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{funsVarTk}
\alias{funsVarTk}
\alias{varTk}
\alias{varTkaij}
\title{Variance of Cuzick and Edwards \eqn{T_k} Test statistic}
\usage{
varTk(dat, n1, k, nonzero.mat = TRUE, ...)

varTkaij(n1, k, a)
}
\arguments{
\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point, used in \code{VarTk} only.}

\item{n1}{Number of cases}

\item{k}{Integer specifying the number of NNs (of subject \eqn{i})}

\item{nonzero.mat}{A logical argument (default is \code{TRUE}) to determine whether the \eqn{A} matrix or the matrix of
nonzero locations of the \eqn{A} matrix will be used in the computation of \eqn{N_s} and \eqn{N_t}.
If \code{TRUE} the nonzero location matrix is used, otherwise the \eqn{A} matrix itself is used. Used in \code{VarTk} only.}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function. Used in \code{VarTk} only.}

\item{a}{The \eqn{A=(a_{ij})} matrix, used in \code{VarTkaij} only.}
}
\value{
The function \code{VarTk} returns a \code{list} with the elements
\item{var.Tk}{The (finite sample) variance of Cuzick and Edwards \eqn{T_k} test statistic for disease clustering}
\item{Ns}{The \eqn{N_s} value standing for the number of ordered pairs for which \code{k}NN relation is symmetric,
see the description.}
\item{Nt}{The \eqn{N_t} value standing for the number of triplets \eqn{(i,j,l)} \eqn{i,j}, and \eqn{l} distinct so that
\eqn{j} is among \code{k}NNs of \eqn{i} and \eqn{j} is among \code{k}NNs of \eqn{l} see the description.}

The function \code{VarTkaij} returns only \code{var.Tk} as above.
}
\description{
Two functions: \code{VarTk} and \code{VarTkaij}.

Both functions compute the (finite sample) variance of Cuzick and Edwards \eqn{T_k} test statistic based on the 
number of cases within \code{k}NNs of the cases in the data under RL or CSR independence.

The common arguments for both functions are \code{n1}, representing the number of cases and \code{k}.
The number of cases are denoted as \eqn{n_1} and number of controls as \eqn{n_0} in this function
to match the case-control class labeling,
which is just the reverse of the labeling in \insertCite{cuzick:1990;textual}{nnspat}.

The logical argument \code{nonzero.mat} (default=\code{TRUE}) is for using the \eqn{A} matrix if \code{FALSE} or just the matrix of nonzero
locations in the \eqn{A} matrix (if \code{TRUE}) for computing \eqn{N_s} and \eqn{N_t}, which are required in the computation of the
variance. \eqn{N_s} and \eqn{N_t} are defined on page 78 of (\insertCite{cuzick:1990;textual}{nnspat}) as follows.
\eqn{N_s=\sum_i\sum_j a_{ij} a_{ji}} (i.e., number of ordered pairs for which \code{k}NN relation is symmetric)
and \eqn{N_t= \sum \sum_{i \ne l}\sum a_{ij} a_{lj}} (i.e, number of triplets \eqn{(i,j,l)} \eqn{i,j}, and \eqn{l} distinct so that
\eqn{j} is among \code{k}NNs of \eqn{i} and \eqn{j} is among \code{k}NNs of \eqn{l}).

The function \code{VarTkaij} uses Toshiro Tango's moments formulas based on the \eqn{A=(a_{ij})} matrix
(and is equivalent to the function \code{VarTk}, see \insertCite{tango:2007;textual}{nnspat},
where \eqn{a_{ij}(k) = 1} if \eqn{z_j} is among the \code{k}NNs of \eqn{z_i} and 0 otherwise.

The function \code{varTkaij} is equivalent to \code{varTk} (with \code{$var} extension).

See (\insertCite{cuzick:1990,tango:2007;textual}{nnspat}).
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(0:1,n,replace = TRUE)  #or try cls<-rep(0:1,c(10,10))
n1<-sum(cls==1)
k<-2 #try also 2,3

a<-aij.mat(Y,k)

varTk(Y,n1,k)
varTk(Y,n1,k,nonzero.mat=FALSE)
varTk(Y,n1,k,method="max")

n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(0:1,n,replace = TRUE)  #or try cls<-rep(0:1,c(10,10))
n1<-sum(cls==1)
k<-1 #try also 2,3, sample(1:5,1)

a<-aij.mat(Y,k)

varTkaij(n1,k,a)
varTk(Y,n1,k)$var

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{asyvarTk}}
}
\author{
Elvan Ceyhan
}
