% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{funsZcell.tct}
\alias{funsZcell.tct}
\alias{Zcell.tct.ct}
\alias{Zcell.tct}
\title{Types I-IV Cell-specific Z Tests of Segregation based on NNCTs}
\usage{
Zcell.tct.ct(
  ct,
  covN,
  type = "III",
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95
)

Zcell.tct(
  dat,
  lab,
  type = "III",
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{ct}{A nearest neighbor contingency table, 
used in \code{Zcell.tct.ct} only}

\item{covN}{The \eqn{k^2 \times k^2} covariance matrix of 
row-wise vectorized cell counts of NNCT, \code{ct};
used in \code{Zcell.tct.ct} only.}

\item{type}{The type of the cell-specific test, 
default=\code{"III"}. 
Takes on values \code{"I"}-\code{"IV"} (or 
equivalently \code{1-4}, respectively.}

\item{alternative}{Type of the alternative hypothesis in the test, 
one of \code{"two.sided"}, \code{"less"} or \code{"greater"}.}

\item{conf.level}{Level of the upper and lower confidence limits, 
default is \code{0.95}, for the \eqn{T_{ij}} values}

\item{dat}{The data set in one or higher dimensions, 
each row corresponds to a data point,
used in \code{Zcell.tct} only}

\item{lab}{The \code{vector} of class labels (numerical or categorical), 
used in \code{Zcell.tct} only}

\item{\dots}{are for further arguments, 
such as \code{method} and \code{p}, 
passed to the \code{\link[stats]{dist}} function, 
used in \code{Zcell.tct} only}
}
\value{
A \code{list} with the elements
\item{statistic}{The \code{matrix} of Types I-IV cell-specific test statistics}
\item{stat.names}{Name of the test statistics}
\item{p.value}{The \code{matrix} of \eqn{p}-values 
for the hypothesis test 
for the corresponding alternative}
\item{LCL,UCL}{Matrix of lower and upper confidence levels for 
the \eqn{T_{ij}} values at the given confidence
level \code{conf.level} and depends on the type of \code{alternative}.}
\item{conf.int}{The confidence interval for the estimates, 
it is \code{NULL} here, since we provide the \code{UCL} and \code{LCL}
in \code{matrix} form.}
\item{cnf.lvl}{Level of the upper and 
lower confidence limits of the entries,
provided in \code{conf.level}.}
\item{estimate}{Estimates of the parameters, 
i.e., matrix of the observed \eqn{T_{ij}} values which is the TCT}
\item{est.name,est.name2}{Names of the estimates, 
both are same in this function}
\item{null.value}{Matrix of hypothesized null values 
for the parameters which are expected values of 
\eqn{T_{ij}} values in the TCT.}
\item{null.name}{Name of the null values}
\item{alternative}{Type of the alternative hypothesis in the test, 
one of \code{"two.sided"}, \code{"less"} or \code{"greater"}}
\item{method}{Description of the hypothesis test}
\item{ct.name}{Name of the contingency table, \code{ct}, 
returned by \code{Zcell.tct.ct} only}
\item{data.name}{Name of the data set, \code{dat}, 
returned by \code{Zcell.tct} only}
}
\description{
Two functions: \code{Zcell.tct.ct} and \code{Zcell.tct}.

All functions are objects of class \code{"cellhtest"} 
but with different arguments (see the parameter list below).
Each one performs hypothesis tests of deviations of 
entries of types I-IV TCT, \eqn{T_{ij}}, 
from their expected values under RL 
or CSR for each entry.
The test for each entry \eqn{i,j} is based on 
the normal approximation of the corresponding \eqn{T_{ij}} value
and are due to \insertCite{ceyhan:jkss-posthoc-2017;textual}{nnspat}.

Each function yields a contingency table of the test statistics, 
\eqn{p}-values for the corresponding 
alternative, expected values (i.e., null value(s)), 
lower and upper confidence levels, and sample estimates
(i.e., observed values) for the \eqn{T_{ij}} values 
and also names of the test statistics, estimates, 
null values, the description of the test, 
and the data set used.

The null hypothesis for each entry \eqn{i,j} is that 
the corresponding value \eqn{T_{ij}} is equal to 
the expected value under RL or CSR, 
see \insertCite{ceyhan:jkss-posthoc-2017;textual}{nnspat}
for more detail.

See also (\insertCite{ceyhan:jkss-posthoc-2017;textual}{nnspat}) 
and references therein.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv)

type<-"I" #try also "II", "III", and "IV"
Zcell.tct(Y,cls,type)
Zcell.tct(Y,cls,type,alt="g")
Zcell.tct(Y,cls,type,method="max")

Zcell.tct.ct(ct,covN)
Zcell.tct.ct(ct,covN,type)
Zcell.tct.ct(ct,covN,type,alt="g")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
Zcell.tct(Y,cls,type)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv)

Zcell.tct(Y,cls,type)
Zcell.tct.ct(ct,covN,type)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Zcell.nnct.ct}} and \code{\link{Zcell.nnct}}
}
\author{
Elvan Ceyhan
}
