% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{ipd.mat.euc}
\alias{ipd.mat.euc}
\title{Euclidean Interpoint Distance Matrix}
\usage{
ipd.mat.euc(x, y = NULL)
}
\arguments{
\item{x}{A set of points in matrix or data frame form 
where points correspond to the rows.}

\item{y}{A set of points in matrix or data frame form 
where points correspond to the rows (default=\code{NULL}).}
}
\value{
A distance matrix whose  \eqn{i,j}-th entry is 
the Euclidean distance between row \eqn{i} of \code{x} and
row \eqn{j} of \code{y} if \code{y} is provided, 
otherwise  \eqn{i,j}-th entry is 
the Euclidean distance between rows \eqn{i} and \eqn{j} of \code{x}.
}
\description{
Returns the Euclidean interpoint distance (IPD) matrix of 
a given the set of points \code{x} and \code{y} using two for loops 
with the \code{\link{euc.dist}} function of the current package.
If \code{y} is provided (default=\code{NULL}) 
it yields a matrix of Euclidean distances 
between the rows of \code{x} and rows of \code{y},
otherwise it provides a square matrix with \eqn{i,j}-th entry 
being the Euclidean distance between row \eqn{i} and row \eqn{j} of \code{x}. 
This function is different from 
the \code{\link{ipd.mat}} function in this package.
\code{\link{ipd.mat}} returns the full distance matrix 
for a variety of distance metrics (including the Euclidean metric),
while \code{\link{ipd.mat.euc}} uses the Euclidean distance metric only.
\code{ipd.mat.euc(X)} and \code{ipd.mat(X)} yield 
the same output for a set of points \code{X},
as the default metric in \code{\link{ipd.mat}} is also \code{"euclidean"}.
}
\examples{
#3D data points
n<-3
X<-matrix(runif(3*n),ncol=3)
ipd.mat.euc(X)

n<-5
Y<-matrix(runif(3*n),ncol=3)
ipd.mat.euc(X,Y)
ipd.mat.euc(X[1,],Y)
ipd.mat.euc(c(.1,.2,.3),Y)
ipd.mat.euc(X[1,],Y[3,])

#1D data points
X<-as.matrix(runif(3)) # need to be entered as a matrix with one column
#(i.e., a column vector), hence X<-runif(3) would not work
ipd.mat.euc(X)

Y<-as.matrix(runif(5))
ipd.mat.euc(X,Y)
ipd.mat.euc(X[1,],Y)
ipd.mat.euc(X[1,],Y[3,])

}
\seealso{
\code{\link[stats]{dist}}, \code{\link{ipd.mat.euc}}, 
and \code{\link{dist.std.data}}
}
\author{
Elvan Ceyhan
}
