% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{var.tct}
\alias{var.tct}
\title{Variances of Entries in a TCT}
\usage{
var.tct(ct, covN, type = "III")
}
\arguments{
\item{ct}{A nearest neighbor contingency table}

\item{covN}{The \eqn{k^2 \times k^2} covariance matrix of row-wise vectorized cell counts of NNCT, \code{ct}.}

\item{type}{The type of the cell-specific test, default=\code{"III"}. Takes on values \code{"I"}-\code{"IV"} (or 
equivalently \code{1-4}, respectively.}
}
\value{
A \code{matrix} of same dimension as, \code{ct}, 
whose entries are the variances of
the entries in the TCT for the corresponding type of cell-specific test.
The row and column names are inherited from \code{ct}.
}
\description{
Returns the variances of \eqn{T_{ij}} values 
for \eqn{i,j=1,\ldots,k} in the TCT in matrix form which
is of the same dimension as TCT for types I-IV tests. 
The argument \code{covN} must be the covariance 
between \eqn{N_{ij}} values which are obtained 
from the NNCT by row-wise
vectorization. type determines the type of the test
for which variances are to be computed, with default=\code{"III"}.
These variances are valid under RL 
or conditional on \eqn{Q} and \eqn{R} under CSR.

See also 
(\insertCite{ceyhan:SJScorrected2010,ceyhan:jkss-posthoc-2017;textual}{nnspat}).
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv)

var.tct(ct,covN,"I")
var.tct(ct,covN,2)
var.tct(ct,covN,"III")
var.tct(ct,covN,"IV")

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)

covN<-cov.nnct(ct,varN,Qv,Rv)

var.tct(ct,covN,"I")
var.tct(ct,covN,2)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{var.nnct}}, \code{\link{var.tctI}}, 
\code{\link{var.tctIII}}, \code{\link{var.tctIV}} ,
and \code{\link{cov.tct}}
}
\author{
Elvan Ceyhan
}
