% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/045_sym_natd_ln.R
\name{sym_natd_ln}
\alias{sym_natd_ln}
\alias{sym_natd_ln.default}
\alias{sym_natd_ln.formula}
\title{Symmetric natural-distribution label noise}
\usage{
\method{sym_natd_ln}{default}(x, y, level, sortid = TRUE, ...)

\method{sym_natd_ln}{formula}(formula, data, ...)
}
\arguments{
\item{x}{a data frame of input attributes.}

\item{y}{a factor vector with the output class of each sample.}

\item{level}{a double in [0,1] with the noise level to be introduced.}

\item{sortid}{a logical indicating if the indices must be sorted at the output (default: \code{TRUE}).}

\item{...}{other options to pass to the function.}

\item{formula}{a formula with the output class and, at least, one input attribute.}

\item{data}{a data frame in which to interpret the variables in the formula.}
}
\value{
An object of class \code{ndmodel} with elements:
\item{xnoise}{a data frame with the noisy input attributes.}
\item{ynoise}{a factor vector with the noisy output class.}
\item{numnoise}{an integer vector with the amount of noisy samples per class.}
\item{idnoise}{an integer vector list with the indices of noisy samples.}
\item{numclean}{an integer vector with the amount of clean samples per class.}
\item{idclean}{an integer vector list with the indices of clean samples.}
\item{distr}{an integer vector with the samples per class in the original data.}
\item{model}{the full name of the noise introduction model used.}
\item{param}{a list of the argument values.}
\item{call}{the function call.}
}
\description{
Introduction of \emph{Symmetric natural-distribution label noise} into a classification dataset.
}
\details{
\emph{Symmetric natural-distribution label noise} randomly selects (\code{level}·100)\% of the samples
in the dataset with independence of their class. Then, the labels of these samples are randomly
replaced by other different ones within the set of class labels. When noise for a certain 
class occurs, another class with a probability proportional to the natural class distribution 
replaces it.
}
\note{
Noise model adapted from the papers in References.
}
\examples{
# load the dataset
data(iris2D)

# usage of the default method
set.seed(9)
outdef <- sym_natd_ln(x = iris2D[,-ncol(iris2D)], y = iris2D[,ncol(iris2D)], level = 0.1)

# show results
summary(outdef, showid = TRUE)
plot(outdef)

# usage of the method for class formula
set.seed(9)
outfrm <- sym_natd_ln(formula = Species ~ ., data = iris2D, level = 0.1)

# check the match of noisy indices
identical(outdef$idnoise, outfrm$idnoise)

}
\references{
R. C. Prati, J. Luengo, and F. Herrera. 
\strong{Emerging topics and challenges of learning from noisy data in nonstandard classification: 
a survey beyond binary class noise}. \emph{Knowledge and Information Systems}, 60(1):63–97, 2019.
\doi{10.1007/s10115-018-1244-4}.
}
\seealso{
\code{\link{sym_nuni_ln}}, \code{\link{sym_adj_ln}}, \code{\link{print.ndmodel}}, \code{\link{summary.ndmodel}}, \code{\link{plot.ndmodel}}
}
